/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server.quorum;

import java.net.InetSocketAddress;
import java.net.Socket;
import javax.management.ObjectName;
import org.apache.storm.shade.org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.storm.shade.org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.storm.shade.org.apache.zookeeper.server.quorum.LearnerHandlerMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerHandlerBean
implements LearnerHandlerMXBean,
ZKMBeanInfo {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerHandlerBean.class);
    private final LearnerHandler learnerHandler;
    private final String remoteAddr;

    public LearnerHandlerBean(LearnerHandler learnerHandler, Socket socket) {
        this.learnerHandler = learnerHandler;
        InetSocketAddress sockAddr = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.remoteAddr = sockAddr == null ? "Unknown" : sockAddr.getAddress().getHostAddress() + ":" + sockAddr.getPort();
    }

    @Override
    public String getName() {
        return MBeanRegistry.getInstance().makeFullPath("Learner_Connections", ObjectName.quote(this.remoteAddr), String.format("\"id:%d\"", this.learnerHandler.getSid()));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public void terminateConnection() {
        LOG.info("terminating learner handler connection on demand {}", (Object)this.toString());
        this.learnerHandler.shutdown();
    }

    public String toString() {
        return "LearnerHandlerBean{remoteIP=" + this.remoteAddr + ",ServerId=" + this.learnerHandler.getSid() + "}";
    }
}

