/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jctools.queues;

import java.util.Arrays;
import org.apache.storm.shade.org.jctools.queues.MpUnboundedXaddChunk;
import org.apache.storm.shade.org.jctools.util.UnsafeLongArrayAccess;

public final class MpmcUnboundedXaddChunk<E>
extends MpUnboundedXaddChunk<MpmcUnboundedXaddChunk<E>, E> {
    private final long[] sequence;

    public MpmcUnboundedXaddChunk(long index, MpmcUnboundedXaddChunk<E> prev, int size, boolean pooled) {
        super(index, prev, size, pooled);
        if (pooled) {
            this.sequence = UnsafeLongArrayAccess.allocateLongArray(size);
            Arrays.fill(this.sequence, -1L);
        } else {
            this.sequence = null;
        }
    }

    public void soSequence(int index, long e) {
        assert (this.isPooled());
        UnsafeLongArrayAccess.soLongElement(this.sequence, UnsafeLongArrayAccess.calcLongElementOffset(index), e);
    }

    public long lvSequence(int index) {
        assert (this.isPooled());
        return UnsafeLongArrayAccess.lvLongElement(this.sequence, UnsafeLongArrayAccess.calcLongElementOffset(index));
    }

    public void spinForSequence(int index, long e) {
        assert (this.isPooled());
        long[] sequence = this.sequence;
        long offset = UnsafeLongArrayAccess.calcLongElementOffset(index);
        while (UnsafeLongArrayAccess.lvLongElement(sequence, offset) != e) {
        }
    }
}

