/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jctools.queues.atomic.unpadded;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.storm.shade.org.jctools.queues.atomic.AtomicQueueUtil;
import org.apache.storm.shade.org.jctools.queues.atomic.unpadded.MpscChunkedAtomicUnpaddedArrayQueueColdProducerFields;
import org.apache.storm.shade.org.jctools.util.Pow2;

public class MpscChunkedAtomicUnpaddedArrayQueue<E>
extends MpscChunkedAtomicUnpaddedArrayQueueColdProducerFields<E> {
    public MpscChunkedAtomicUnpaddedArrayQueue(int maxCapacity) {
        super(Math.max(2, Math.min(1024, Pow2.roundToPowerOfTwo(maxCapacity / 8))), maxCapacity);
    }

    public MpscChunkedAtomicUnpaddedArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected long availableInQueue(long pIndex, long cIndex) {
        return this.maxQueueCapacity - (pIndex - cIndex);
    }

    @Override
    public int capacity() {
        return (int)(this.maxQueueCapacity / 2L);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> buffer) {
        return AtomicQueueUtil.length(buffer);
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask;
    }
}

