/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context;

import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.LogLevel;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.LoggingSystemRegister;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.SLF4JPrintStreamManager;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4JInitialiser;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.exceptionhandlers.ExceptionHandlingStrategyFactory;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.context.exceptionhandlers.LogPerLineExceptionHandlingStrategyFactory;
import org.apache.storm.shade.uk.org.lidalia.sysoutslf4j.system.SLF4JPrintStreamImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SysOutOverSLF4J {
    private static final LoggingSystemRegister LOGGING_SYSTEM_REGISTER = new LoggingSystemRegister();
    private static final SLF4JPrintStreamManager SLF4J_PRINT_STREAM_MANAGER = new SLF4JPrintStreamManager();

    static {
        SysOutOverSLF4JInitialiser sysOutOverSLF4JInitialiser = new SysOutOverSLF4JInitialiser(LOGGING_SYSTEM_REGISTER);
        Logger loggerImplementation = LoggerFactory.getLogger((String)"ROOT");
        sysOutOverSLF4JInitialiser.initialise(loggerImplementation);
    }

    public static void sendSystemOutAndErrToSLF4J() {
        SysOutOverSLF4J.sendSystemOutAndErrToSLF4J(LogLevel.INFO, LogLevel.ERROR);
    }

    public static void sendSystemOutAndErrToSLF4J(LogLevel outLevel, LogLevel errLevel) {
        ExceptionHandlingStrategyFactory exceptionHandlingStrategyFactory = LogPerLineExceptionHandlingStrategyFactory.getInstance();
        SysOutOverSLF4J.sendSystemOutAndErrToSLF4J(outLevel, errLevel, exceptionHandlingStrategyFactory);
    }

    public static void sendSystemOutAndErrToSLF4J(ExceptionHandlingStrategyFactory exceptionHandlingStrategyFactory) {
        SysOutOverSLF4J.sendSystemOutAndErrToSLF4J(LogLevel.INFO, LogLevel.ERROR, exceptionHandlingStrategyFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendSystemOutAndErrToSLF4J(LogLevel outLevel, LogLevel errLevel, ExceptionHandlingStrategyFactory exceptionHandlingStrategyFactory) {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            SLF4J_PRINT_STREAM_MANAGER.sendSystemOutAndErrToSLF4J(outLevel, errLevel, exceptionHandlingStrategyFactory);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSendingSystemOutAndErrToSLF4J() {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            SLF4J_PRINT_STREAM_MANAGER.stopSendingSystemOutAndErrToSLF4J();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoreOriginalSystemOutputs() {
        Class<System> clazz = System.class;
        synchronized (System.class) {
            SLF4J_PRINT_STREAM_MANAGER.restoreOriginalSystemOutputsIfNecessary();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void registerLoggingSystem(String packageName) {
        LOGGING_SYSTEM_REGISTER.registerLoggingSystem(packageName);
    }

    public static void unregisterLoggingSystem(String packageName) {
        LOGGING_SYSTEM_REGISTER.unregisterLoggingSystem(packageName);
    }

    public static boolean isInLoggingSystem(String className) {
        return LOGGING_SYSTEM_REGISTER.isInLoggingSystem(className);
    }

    private SysOutOverSLF4J() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static boolean systemOutputsAreSLF4JPrintStreams() {
        return System.out.getClass().getName().equals(SLF4JPrintStreamImpl.class.getName());
    }
}

