/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationFactoryFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.util.Generics;
import jakarta.validation.Validator;
import java.io.IOException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.jspecify.annotations.Nullable;

public abstract class ConfiguredCommand<T extends Configuration>
extends Command {
    private boolean asynchronous = false;
    private @Nullable T configuration;

    protected ConfiguredCommand(String name, String description) {
        super(name, description);
    }

    protected Class<T> getConfigurationClass() {
        return Generics.getTypeParameter(this.getClass(), Configuration.class);
    }

    public @Nullable T getConfiguration() {
        return this.configuration;
    }

    @Override
    public void configure(Subparser subparser) {
        this.addFileArgument(subparser);
    }

    protected Argument addFileArgument(Subparser subparser) {
        return subparser.addArgument(new String[]{"file"}).nargs("?").help("application configuration file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Bootstrap<?> wildcardBootstrap, Namespace namespace) throws Exception {
        Bootstrap<?> bootstrap = wildcardBootstrap;
        this.configuration = this.parseConfiguration(bootstrap.getConfigurationFactoryFactory(), bootstrap.getConfigurationSourceProvider(), bootstrap.getValidatorFactory().getValidator(), namespace.getString("file"), this.getConfigurationClass(), bootstrap.getObjectMapper());
        try {
            if (this.configuration != null) {
                ((Configuration)this.configuration).getLoggingFactory().configure(bootstrap.getMetricRegistry(), bootstrap.getApplication().getName());
            }
            this.run(bootstrap, namespace, this.configuration);
        }
        finally {
            if (!this.asynchronous) {
                this.cleanup();
            } else if (this.configuration != null) {
                ((Configuration)this.configuration).getLoggingFactory().stop();
            }
        }
    }

    protected void cleanupAsynchronously() {
        this.asynchronous = true;
    }

    protected void cleanup() {
        if (this.configuration != null) {
            ((Configuration)this.configuration).getLoggingFactory().stop();
        }
    }

    protected abstract void run(Bootstrap<T> var1, Namespace var2, T var3) throws Exception;

    private T parseConfiguration(ConfigurationFactoryFactory<T> configurationFactoryFactory, ConfigurationSourceProvider provider, Validator validator, String path, Class<T> klass, ObjectMapper objectMapper) throws IOException, ConfigurationException {
        ConfigurationFactory configurationFactory = configurationFactoryFactory.create(klass, validator, objectMapper, "dw");
        if (path != null) {
            return (T)((Configuration)configurationFactory.build(provider, path));
        }
        return (T)((Configuration)configurationFactory.build());
    }
}

