/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.common;

import com.codahale.metrics.ScheduledReporter;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.util.Duration;

public class ScheduledReporterManager
implements Managed {
    private final ScheduledReporter reporter;
    private final Duration period;
    private final boolean reportOnStop;

    public ScheduledReporterManager(ScheduledReporter reporter, Duration period) {
        this(reporter, period, false);
    }

    public ScheduledReporterManager(ScheduledReporter reporter, Duration period, boolean reportOnStop) {
        this.reporter = reporter;
        this.period = period;
        this.reportOnStop = reportOnStop;
    }

    public void start() throws Exception {
        this.reporter.start(this.period.getQuantity(), this.period.getUnit());
    }

    public void stop() throws Exception {
        try {
            if (this.reportOnStop) {
                this.reporter.report();
            }
        }
        finally {
            this.reporter.stop();
        }
    }
}

