/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RpcThrottlingException
extends HBaseIOException {
    private static final String[] MSG_TYPE = new String[]{"number of requests exceeded", "request size limit exceeded", "number of read requests exceeded", "number of write requests exceeded", "write size limit exceeded", "read size limit exceeded", "request capacity unit exceeded", "read capacity unit exceeded", "write capacity unit exceeded", "atomic request number exceeded", "atomic read size exceeded", "atomic write size exceeded", "request handler usage time exceeded"};
    private static final String MSG_WAIT = " - wait ";
    private long waitInterval;
    private Type type;

    public RpcThrottlingException(String msg) {
        super(msg);
        for (int i = 0; i < MSG_TYPE.length; ++i) {
            int index = msg.indexOf(MSG_TYPE[i]);
            if (index < 0) continue;
            String waitTimeStr = msg.substring(index + MSG_TYPE[i].length() + MSG_WAIT.length());
            this.type = Type.values()[i];
            this.waitInterval = RpcThrottlingException.timeFromString(waitTimeStr);
            break;
        }
    }

    public RpcThrottlingException(Type type, long waitInterval, String msg) {
        super(msg);
        this.waitInterval = waitInterval;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public long getWaitInterval() {
        return this.waitInterval;
    }

    public static void throwNumRequestsExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.NumRequestsExceeded, waitInterval);
    }

    public static void throwRequestSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.RequestSizeExceeded, waitInterval);
    }

    public static void throwNumReadRequestsExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.NumReadRequestsExceeded, waitInterval);
    }

    public static void throwNumWriteRequestsExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.NumWriteRequestsExceeded, waitInterval);
    }

    public static void throwWriteSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.WriteSizeExceeded, waitInterval);
    }

    public static void throwReadSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.ReadSizeExceeded, waitInterval);
    }

    public static void throwRequestCapacityUnitExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.RequestCapacityUnitExceeded, waitInterval);
    }

    public static void throwReadCapacityUnitExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.ReadCapacityUnitExceeded, waitInterval);
    }

    public static void throwWriteCapacityUnitExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.WriteCapacityUnitExceeded, waitInterval);
    }

    public static void throwAtomicRequestNumberExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.AtomicRequestNumberExceeded, waitInterval);
    }

    public static void throwAtomicReadSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.AtomicReadSizeExceeded, waitInterval);
    }

    public static void throwAtomicWriteSizeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.AtomicWriteSizeExceeded, waitInterval);
    }

    public static void throwRequestHandlerUsageTimeExceeded(long waitInterval) throws RpcThrottlingException {
        RpcThrottlingException.throwThrottlingException(Type.RequestHandlerUsageTimeExceeded, waitInterval);
    }

    private static void throwThrottlingException(Type type, long waitInterval) throws RpcThrottlingException {
        String msg = MSG_TYPE[type.ordinal()] + MSG_WAIT + RpcThrottlingException.stringFromMillis(waitInterval);
        throw new RpcThrottlingException(type, waitInterval, msg);
    }

    protected static String stringFromMillis(long millis) {
        StringBuilder buf = new StringBuilder();
        long hours = millis / 3600000L;
        long rem = millis % 3600000L;
        long minutes = rem / 60000L;
        long seconds = (rem %= 60000L) / 1000L;
        long milliseconds = rem % 1000L;
        if (hours != 0L) {
            buf.append(hours);
            buf.append(hours > 1L ? "hrs, " : "hr, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append(minutes > 1L ? "mins, " : "min, ");
        }
        if (seconds != 0L) {
            buf.append(seconds);
            buf.append("sec, ");
        }
        buf.append(milliseconds);
        buf.append("ms");
        return buf.toString();
    }

    protected static long timeFromString(String timeDiff) {
        Pattern pattern = Pattern.compile("^(?:(\\d+)hrs?, )?(?:(\\d+)mins?, )?(?:(\\d+)sec[, ]{0,2})?(?:(\\d+)ms)?");
        long[] factors = new long[]{3600000L, 60000L, 1000L, 1L};
        Matcher m = pattern.matcher(timeDiff);
        if (m.find()) {
            int numGroups = m.groupCount();
            long time = 0L;
            for (int j = 1; j <= numGroups; ++j) {
                String group = m.group(j);
                if (group == null) continue;
                time += (long)Math.round(Float.parseFloat(group) * (float)factors[j - 1]);
            }
            return time;
        }
        return -1L;
    }

    @InterfaceAudience.Public
    public static enum Type {
        NumRequestsExceeded,
        RequestSizeExceeded,
        NumReadRequestsExceeded,
        NumWriteRequestsExceeded,
        WriteSizeExceeded,
        ReadSizeExceeded,
        RequestCapacityUnitExceeded,
        ReadCapacityUnitExceeded,
        WriteCapacityUnitExceeded,
        AtomicRequestNumberExceeded,
        AtomicReadSizeExceeded,
        AtomicWriteSizeExceeded,
        RequestHandlerUsageTimeExceeded;

    }
}

