/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.localizer.LocalResource;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorUtils.class);
    private static final SupervisorUtils INSTANCE;
    private static SupervisorUtils _instance;

    public static void setInstance(SupervisorUtils u) {
        _instance = u;
    }

    public static void resetInstance() {
        _instance = INSTANCE;
    }

    public static String getNumaIdForPort(Integer port, Map<String, Object> supervisorConf) {
        Map<String, Object> validatedNumaMap = SupervisorUtils.getNumaMap(supervisorConf);
        for (Map.Entry<String, Object> numaEntry : validatedNumaMap.entrySet()) {
            Map numaMap = (Map)numaEntry.getValue();
            List portList = (List)numaMap.get("numa.ports");
            if (!portList.contains(port)) continue;
            return numaEntry.getKey();
        }
        return null;
    }

    public static Set<Integer> getNumaPorts(Map<String, Object> supervisorConf) {
        HashSet<Integer> numaPorts = new HashSet<Integer>();
        Map<String, Object> validatedNumaMap = SupervisorUtils.getNumaMap(supervisorConf);
        for (Map.Entry<String, Object> numaEntry : validatedNumaMap.entrySet()) {
            Map numaMap = (Map)numaEntry.getValue();
            List portList = (List)numaMap.get("numa.ports");
            numaPorts.addAll(portList);
        }
        return numaPorts;
    }

    public static List<Integer> getSlotsPorts(Map<String, Object> supervisorConf) {
        ArrayList<Integer> slotsPorts = new ArrayList<Integer>();
        List ports = supervisorConf.getOrDefault("supervisor.slots.ports", new ArrayList());
        for (Number port : ports) {
            slotsPorts.add(port.intValue());
        }
        Set<Integer> numaPorts = SupervisorUtils.getNumaPorts(supervisorConf);
        numaPorts.removeAll(slotsPorts);
        slotsPorts.addAll(numaPorts);
        return slotsPorts;
    }

    public static void rmrAsUser(Map<String, Object> conf, String id, String path) throws IOException {
        String user = ServerUtils.getFileOwner(path);
        String logPreFix = "rmr " + id;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("rmr");
        commands.add(path);
        ClientSupervisorUtils.processLauncherAndWait(conf, (String)user, commands, null, (String)logPreFix);
        if (Utils.checkFileExists((String)path)) {
            throw new RuntimeException(path + " was not deleted.");
        }
    }

    public static boolean shouldUncompressBlob(Map<String, Object> blobInfo) {
        return ObjectReader.getBoolean((Object)blobInfo.get("uncompress"), (boolean)false);
    }

    public static boolean blobNeedsWorkerRestart(Map<String, Object> blobInfo) {
        return ObjectReader.getBoolean((Object)blobInfo.get("workerRestart"), (boolean)false);
    }

    public static List<LocalResource> blobstoreMapToLocalresources(Map<String, Map<String, Object>> blobstoreMap) {
        ArrayList<LocalResource> localResourceList = new ArrayList<LocalResource>();
        if (blobstoreMap != null) {
            for (Map.Entry<String, Map<String, Object>> map : blobstoreMap.entrySet()) {
                Map<String, Object> blobConf = map.getValue();
                LocalResource localResource = new LocalResource(map.getKey(), SupervisorUtils.shouldUncompressBlob(blobConf), SupervisorUtils.blobNeedsWorkerRestart(blobConf));
                localResourceList.add(localResource);
            }
        }
        return localResourceList;
    }

    public static Collection<String> supervisorWorkerIds(Map<String, Object> conf) {
        String workerRoot = ConfigUtils.workerRoot(conf);
        return ConfigUtils.readDirContents((String)workerRoot);
    }

    public static Map<String, LSWorkerHeartbeat> readWorkerHeartbeats(Map<String, Object> conf) {
        return _instance.readWorkerHeartbeatsImpl(conf);
    }

    private static LSWorkerHeartbeat readWorkerHeartbeat(Map<String, Object> conf, String workerId) {
        return _instance.readWorkerHeartbeatImpl(conf, workerId);
    }

    public static Map<String, Object> getNumaMap(Map<String, Object> stormConf) {
        Object numa = stormConf.get("supervisor.numa.meta");
        if (numa == null) {
            return Collections.emptyMap();
        }
        return (Map)numa;
    }

    public Map<String, LSWorkerHeartbeat> readWorkerHeartbeatsImpl(Map<String, Object> conf) {
        HashMap<String, LSWorkerHeartbeat> workerHeartbeats = new HashMap<String, LSWorkerHeartbeat>();
        Collection<String> workerIds = SupervisorUtils.supervisorWorkerIds(conf);
        for (String workerId : workerIds) {
            LSWorkerHeartbeat whb = SupervisorUtils.readWorkerHeartbeat(conf, workerId);
            workerHeartbeats.put(workerId, whb);
        }
        return workerHeartbeats;
    }

    protected LSWorkerHeartbeat readWorkerHeartbeatImpl(Map<String, Object> conf, String workerId) {
        try {
            LocalState localState = ConfigUtils.workerState(conf, (String)workerId);
            return localState.getWorkerHeartBeat();
        }
        catch (Exception e) {
            LOG.warn("Failed to read local heartbeat for workerId : {},Ignoring exception.", (Object)workerId, (Object)e);
            return null;
        }
    }

    static {
        _instance = INSTANCE = new SupervisorUtils();
    }
}

