/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.healthcheck;

import com.codahale.metrics.Meter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthChecker {
    private static final Logger LOG = LoggerFactory.getLogger(HealthChecker.class);
    private static final String FAILED = "failed";
    private static final String SUCCESS = "success";
    private static final String TIMEOUT = "timeout";
    private static final String FAILED_WITH_EXIT_CODE = "failed_with_exit_code";

    public static int healthCheck(Map<String, Object> conf, StormMetricsRegistry metricRegistry) {
        String healthDir = ServerConfigUtils.absoluteHealthCheckDir(conf);
        ArrayList<String> results = new ArrayList<String>();
        if (healthDir != null) {
            File parentFile = new File(healthDir);
            ArrayList<String> healthScripts = new ArrayList<String>();
            if (parentFile.exists()) {
                File[] list;
                for (File f : list = parentFile.listFiles()) {
                    if (f.isDirectory() || !f.canExecute()) continue;
                    healthScripts.add(f.getAbsolutePath());
                }
            }
            for (String script : healthScripts) {
                String result = HealthChecker.processScript(conf, script);
                results.add(result);
                LOG.info("The healthcheck script [ {} ] exited with status: {}", (Object)script, (Object)result);
            }
        }
        if (results.contains(FAILED) || results.contains(FAILED_WITH_EXIT_CODE)) {
            LOG.warn("The supervisor healthchecks failed!!!");
            return 1;
        }
        if (results.contains(TIMEOUT)) {
            Boolean failOnTimeouts;
            Meter timeoutMeter;
            LOG.warn("The supervisor healthchecks timedout!!!");
            if (metricRegistry != null && (timeoutMeter = metricRegistry.getMeter("supervisor:health-check-timeouts")) != null) {
                timeoutMeter.mark();
            }
            if ((failOnTimeouts = Boolean.valueOf(ObjectReader.getBoolean((Object)conf.get("storm.health.check.fail.on.timeouts"), (boolean)true))).booleanValue()) {
                return 1;
            }
            return 0;
        }
        LOG.info("The supervisor healthchecks succeeded.");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processScript(Map<String, Object> conf, String script) {
        Thread interruptThread = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(script);
            final long timeout = ObjectReader.getLong((Object)conf.get("storm.health.check.timeout.ms"), (Long)5000L);
            final Thread curThread = Thread.currentThread();
            interruptThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(timeout);
                        curThread.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            interruptThread.start();
            process.waitFor();
            interruptThread.interrupt();
            curThread.interrupted();
            if (process.exitValue() != 0) {
                String outMessage = HealthChecker.readFromStream(process.getInputStream());
                String errMessage = HealthChecker.readFromStream(process.getErrorStream());
                LOG.warn("The healthcheck process {} exited with code: {}; output: {}; err: {}.", new Object[]{script, process.exitValue(), outMessage, errMessage});
                if (outMessage.startsWith("ERROR")) {
                    String string = FAILED;
                    return string;
                }
                String string = FAILED_WITH_EXIT_CODE;
                return string;
            }
            String string = SUCCESS;
            return string;
        }
        catch (InterruptedException | ClosedByInterruptException e) {
            LOG.warn("Script:  {} timed out.", (Object)script);
            if (process != null) {
                process.destroyForcibly();
            }
            String string = TIMEOUT;
            return string;
        }
        catch (Exception e) {
            LOG.warn("Script failed with exception: ", (Throwable)e);
            String string = FAILED;
            return string;
        }
        finally {
            if (interruptThread != null) {
                interruptThread.interrupt();
            }
        }
    }

    private static String readFromStream(InputStream is) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String str;
            while ((str = reader.readLine()) != null) {
                stringBuilder.append(str).append("\n");
            }
        }
        return stringBuilder.toString().trim();
    }
}

