/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import java.util.Map;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.nimbus.ITopologyValidator;
import org.apache.storm.utils.WrappedInvalidTopologyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrictTopologyValidator
implements ITopologyValidator {
    private static final Logger LOG = LoggerFactory.getLogger(StrictTopologyValidator.class);

    public void prepare(Map stormConf) {
    }

    public void validate(String topologyName, Map topologyConf, StormTopology topology) throws InvalidTopologyException {
        if (topologyName.contains(".")) {
            throw new WrappedInvalidTopologyException(String.format("Topology name '%s' contains illegal character '.'", topologyName));
        }
        Map spouts = topology.get_spouts();
        for (String spoutName : spouts.keySet()) {
            if (spoutName.contains(".")) {
                throw new WrappedInvalidTopologyException(String.format("Spout name '%s' contains illegal character '.'", spoutName));
            }
            SpoutSpec spoutSpec = (SpoutSpec)spouts.get(spoutName);
            for (String streamName : spoutSpec.get_common().get_streams().keySet()) {
                if (!streamName.contains(".")) continue;
                throw new WrappedInvalidTopologyException(String.format("Stream name '%s' contains illegal character '.'", streamName));
            }
        }
        Map bolts = topology.get_bolts();
        for (String boltName : bolts.keySet()) {
            if (boltName.contains(".")) {
                throw new WrappedInvalidTopologyException(String.format("Bolt name '%s' contains illegal character '.'", boltName));
            }
            Bolt bolt = (Bolt)bolts.get(boltName);
            for (String streamName : bolt.get_common().get_streams().keySet()) {
                if (!streamName.contains(".")) continue;
                throw new WrappedInvalidTopologyException(String.format("Stream name '%s' contains illegal character '.'", streamName));
            }
        }
    }
}

