/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.api;

import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IReducer;

public class ReducedMetric
implements IMetric {
    private final IReducer reducer;
    private Object accumulator;

    public ReducedMetric(IReducer reducer) {
        this.reducer = reducer;
        this.accumulator = this.reducer.init();
    }

    public void update(Object value) {
        this.accumulator = this.reducer.reduce(this.accumulator, value);
    }

    @Override
    public Object getValueAndReset() {
        Object ret = this.reducer.extractResult(this.accumulator);
        this.accumulator = this.reducer.init();
        return ret;
    }
}

