/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.schema.Schema;
import com.google.transconsole.common.messages.Message;
import java.util.List;

public class ExtractedMessage
extends Expression {
    private final Message tcMessage;
    private final ImmutableList<Expression> parameters;

    public ExtractedMessage(Node fromNode, Schema schema, Message tcMessage, List<Expression> parameters) {
        super(fromNode, schema);
        this.tcMessage = Preconditions.checkNotNull(tcMessage);
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public Message getTcMessage() {
        return this.tcMessage;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public ExtractedMessage transformParams(Function<Expression, Expression> function) {
        ImmutableList<Expression> newParams = Util.map(this.parameters, function);
        return new ExtractedMessage(this, this.getSchema(), this.tcMessage, newParams);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitExtractedMessage(this);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof ExtractedMessage && this.equals((ExtractedMessage)that);
    }

    public boolean equals(ExtractedMessage that) {
        return this.equalsExpression(that) && Objects.equal(this.getTcMessage(), that.getTcMessage()) && Objects.equal(this.getParameters(), that.getParameters());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.getTcMessage(), this.getParameters());
    }
}

