/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.factory;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.factory.ResultFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.result.ParamNameAwareResult;
import com.opensymphony.xwork2.util.reflection.ReflectionException;
import com.opensymphony.xwork2.util.reflection.ReflectionExceptionHandler;
import com.opensymphony.xwork2.util.reflection.ReflectionProvider;
import java.util.Map;

public class StrutsResultFactory
implements ResultFactory {
    protected ObjectFactory objectFactory;
    protected ReflectionProvider reflectionProvider;

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Inject
    public void setReflectionProvider(ReflectionProvider provider) {
        this.reflectionProvider = provider;
    }

    @Override
    public Result buildResult(ResultConfig resultConfig, Map<String, Object> extraContext) throws Exception {
        String resultClassName = resultConfig.getClassName();
        Result result = null;
        if (resultClassName != null) {
            Object o = this.objectFactory.buildBean(resultClassName, extraContext);
            Map<String, String> params = resultConfig.getParams();
            if (params != null) {
                this.setParameters(extraContext, o, params);
            }
            if (o instanceof Result) {
                result = (Result)o;
            } else if (o instanceof org.apache.struts2.result.Result) {
                result = Result.adapt((org.apache.struts2.result.Result)o);
            }
            if (result == null) {
                throw new ConfigurationException("Class [" + resultClassName + "] does not implement Result", (Object)resultConfig);
            }
        }
        return result;
    }

    protected void setParameters(Map<String, Object> extraContext, Result result, Map<String, String> params) {
        this.setParametersHelper(extraContext, result, params);
    }

    protected void setParameters(Map<String, Object> extraContext, Object result, Map<String, String> params) {
        if (result instanceof Result) {
            this.setParameters(extraContext, (Result)result, params);
        } else {
            this.setParametersHelper(extraContext, result, params);
        }
    }

    private void setParametersHelper(Map<String, Object> extraContext, Object result, Map<String, String> params) {
        for (Map.Entry<String, String> paramEntry : params.entrySet()) {
            try {
                String name = paramEntry.getKey();
                String value = paramEntry.getValue();
                this.setParameter(result, name, value, extraContext);
            }
            catch (ReflectionException ex) {
                if (!(result instanceof ReflectionExceptionHandler)) continue;
                ((ReflectionExceptionHandler)result).handle(ex);
            }
        }
    }

    protected void setParameter(Result result, String name, String value, Map<String, Object> extraContext) {
        this.setParameterHelper(result, name, value, extraContext);
    }

    private void setParameter(Object result, String name, String value, Map<String, Object> extraContext) {
        if (result instanceof Result) {
            this.setParameter((Result)result, name, value, extraContext);
        } else {
            this.setParameterHelper(result, name, value, extraContext);
        }
    }

    private void setParameterHelper(Object result, String name, String value, Map<String, Object> extraContext) {
        if (result instanceof ParamNameAwareResult) {
            if (((ParamNameAwareResult)result).acceptableParameterName(name, value)) {
                this.reflectionProvider.setProperty(name, value, result, extraContext, true);
            }
        } else {
            this.reflectionProvider.setProperty(name, value, result, extraContext, true);
        }
    }
}

