/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.reflect;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.request.reflect.CannotInstantiateObjectException;

public final class ClassUtil {
    private static final Logger LOG = LogManager.getLogger(ClassUtil.class);

    private ClassUtil() {
    }

    public static <T> Class<? extends T> getClass(String className, Class<T> baseClass) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        return Class.forName(className, true, classLoader).asSubclass(baseClass);
    }

    public static Object instantiate(String className) {
        return ClassUtil.instantiate(className, false);
    }

    public static Object instantiate(String className, boolean returnNull) {
        try {
            Class<Object> namedClass = ClassUtil.getClass(className, Object.class);
            return namedClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (returnNull) {
                return null;
            }
            throw new CannotInstantiateObjectException("Unable to resolve factory class: '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new CannotInstantiateObjectException("Unable to access factory class: '" + className + "'", e);
        }
        catch (InstantiationException e) {
            throw new CannotInstantiateObjectException("Unable to instantiate factory class: '" + className + "'. Make sure that this class has a default constructor", e);
        }
    }

    public static void collectBeanInfo(Class<?> clazz, Map<String, PropertyDescriptor> name2descriptor) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(clazz);
        }
        catch (Exception ex) {
            LOG.debug("Cannot inspect class " + String.valueOf(clazz), (Throwable)ex);
        }
        if (info == null) {
            return;
        }
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            pd.setValue("type", pd.getPropertyType());
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            name2descriptor.put(pd.getName(), pd);
        }
    }
}

