/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.JRExporterGridCell;

public class Grid {
    private final int rowCount;
    private final int columnCount;
    private JRExporterGridCell[] cells;

    public Grid(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cells = new JRExporterGridCell[rowCount * columnCount];
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public GridRow getRow(int row) {
        this.rowBoundsCheck(row);
        return new GridRow(this.cells, row * this.columnCount, this.columnCount);
    }

    private void rowBoundsCheck(int row) {
        if (row < 0 || row >= this.rowCount) {
            throw new IndexOutOfBoundsException("row index " + row + " out of bounds, size " + this.rowCount);
        }
    }

    private void columnBoundsCheck(int column) {
        if (column < 0 || column >= this.columnCount) {
            throw new IndexOutOfBoundsException("column index " + column + " out of bounds, size " + this.columnCount);
        }
    }

    public void set(int row, int column, JRExporterGridCell cell) {
        this.rowBoundsCheck(row);
        this.columnBoundsCheck(column);
        this.cells[row * this.columnCount + column] = cell;
    }

    public JRExporterGridCell get(int row, int column) {
        this.rowBoundsCheck(row);
        this.columnBoundsCheck(column);
        return this.cells[row * this.columnCount + column];
    }
}

