/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.builders;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.MultipleEntryHashMap;

public class XFormURLEncodedBuilder
implements Builder {
    private org.apache.axis2.builder.XFormURLEncodedBuilder xformAxis2Builder = new org.apache.axis2.builder.XFormURLEncodedBuilder();
    private static final QName XFORM_FIRST_ELEMENT = new QName("xformValues");

    public OMElement processDocument(InputStream inputStream, String s, MessageContext messageContext) throws AxisFault {
        SOAPEnvelope soapEnv = (SOAPEnvelope)this.xformAxis2Builder.processDocument(inputStream, s, messageContext);
        SOAPBody body = soapEnv.getBody();
        String httpMethod = (String)messageContext.getProperty("HTTP_METHOD_OBJECT");
        if (body.getFirstElement() == null && "POST".equals(httpMethod) && messageContext.getProperty("requestParameterMap") != null) {
            MultipleEntryHashMap map = (MultipleEntryHashMap)messageContext.getProperty("requestParameterMap");
            SOAPFactory soapFactory = this.getSOAPFactory(messageContext);
            OMElement bodyFirstChild = soapFactory.createOMElement(XFORM_FIRST_ELEMENT, (OMContainer)body);
            BuilderUtil.createSOAPMessageWithoutSchema((SOAPFactory)soapFactory, (OMElement)bodyFirstChild, (MultipleEntryHashMap)map);
        }
        return soapEnv;
    }

    private SOAPFactory getSOAPFactory(MessageContext messageContext) throws AxisFault {
        SOAPFactory soapFactory;
        AxisEndpoint axisEndpoint = (AxisEndpoint)messageContext.getProperty("endpoint");
        if (axisEndpoint != null) {
            AxisBinding axisBinding = axisEndpoint.getBinding();
            String soapVersion = (String)axisBinding.getProperty("wsoap:version");
            soapFactory = this.getSOAPFactory(soapVersion);
        } else {
            soapFactory = this.getSOAPFactory("http://www.w3.org/2003/05/soap-envelope");
        }
        return soapFactory;
    }

    private SOAPFactory getSOAPFactory(String nsURI) throws AxisFault {
        if (nsURI == null) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage((String)"invalidSOAPversion"));
    }
}

