/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.evaluators.Condition;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.ConditionFactory;

public class Parser {
    private Log log = LogFactory.getLog(Parser.class);
    private Condition[] conditions = null;
    private int defaultPriority = -1;

    public Parser() {
    }

    public Parser(int defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public int parse(EvaluatorContext context) {
        for (Condition condition : this.conditions) {
            try {
                if (!condition.getEvaluator().evaluate(context)) continue;
                return condition.getPriority();
            }
            catch (EvaluatorException e) {
                String msg = "Error evaluating the condition with priority :" + condition.getPriority();
                if (this.defaultPriority == -1) {
                    this.log.error((Object)msg, (Throwable)e);
                }
                return this.defaultPriority;
            }
        }
        return this.defaultPriority;
    }

    public void init(OMElement conditions) throws EvaluatorException {
        Iterator it = conditions.getChildElements();
        ConditionFactory rf = new ConditionFactory();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        while (it.hasNext()) {
            OMElement conditionElement = (OMElement)it.next();
            if (!conditionElement.getLocalName().equals("condition")) {
                this.handleException("Only condition elements expected");
            }
            Condition r = null;
            try {
                r = rf.createCondition(conditionElement);
            }
            catch (EvaluatorException e) {
                this.handleException("Error creating condition: " + e.getMessage());
            }
            conditionList.add(r);
        }
        if (conditionList.size() > 1) {
            this.conditions = conditionList.toArray(new Condition[conditionList.size()]);
        } else if (conditionList.size() == 1 && this.defaultPriority == -1) {
            this.handleException("No point in having one rule without a default priority");
        } else {
            this.handleException("One or more conditions should ve specified");
        }
    }

    private void handleException(String message) throws EvaluatorException {
        this.log.error((Object)message);
        throw new EvaluatorException(message);
    }
}

