/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointDefinitionSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.WSDLEndpoint;

public class WSDLEndpointSerializer
extends EndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        OMElement wsdlDoc;
        String uri;
        String portName;
        if (!(endpoint instanceof WSDLEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)endpoint;
        OMElement wsdlElement = this.fac.createOMElement("wsdl", SynapseConstants.SYNAPSE_OMNAMESPACE);
        String serviceName = wsdlEndpoint.getGetOriginalWsdlServiceName();
        if (serviceName != null) {
            wsdlElement.addAttribute("service", serviceName, null);
        }
        if ((portName = wsdlEndpoint.getOriginalWsdlPort()) != null) {
            wsdlElement.addAttribute("port", portName, null);
        }
        if ((uri = wsdlEndpoint.getOriginalWsdlURI()) != null) {
            wsdlElement.addAttribute("uri", uri, null);
        }
        if ((wsdlDoc = wsdlEndpoint.getWsdlDoc()) != null) {
            wsdlElement.addChild((OMNode)wsdlDoc);
        }
        EndpointDefinition epDefinition = wsdlEndpoint.getDefinition();
        EndpointDefinitionSerializer serializer = new EndpointDefinitionSerializer();
        serializer.serializeEndpointDefinition(epDefinition, wsdlElement);
        this.serializeSpecificEndpointProperties(epDefinition, wsdlElement);
        endpointElement.addChild((OMNode)wsdlElement);
        this.serializeProperties(wsdlEndpoint, endpointElement);
        this.serializeCommonAttributes(endpoint, endpointElement);
        return endpointElement;
    }
}

