/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.TemplateMediatorSerializer;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;
import org.apache.synapse.config.xml.endpoints.TemplateSerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.mediators.template.TemplateMediator;

public class TemplateDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(TemplateDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template Deployment from file : " + fileName + " : Started"));
        }
        try {
            Mediator mediator;
            OMElement element = artifactConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
            if (element != null) {
                TemplateFactory templateFactory = new TemplateFactory();
                Template tm = templateFactory.createEndpointTemplate(artifactConfig, properties);
                tm.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint Template named '" + tm.getName() + "' has been built from the file " + fileName));
                }
                this.getSynapseConfiguration().addEndpointTemplate(tm.getName(), tm);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Template Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("Endpoint Template named '" + tm.getName() + "' has been deployed from file : " + fileName));
                return tm.getName();
            }
            element = artifactConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
            if (element != null && (mediator = MediatorFactoryFinder.getInstance().getMediator(artifactConfig, properties)) instanceof TemplateMediator) {
                TemplateMediator tm = (TemplateMediator)mediator;
                tm.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sequence Template named '" + tm.getName() + "' has been built from the file " + fileName));
                }
                tm.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the Template : " + tm.getName()));
                }
                this.getSynapseConfiguration().addSequenceTemplate(tm.getName(), tm);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Template Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("Template named '" + tm.getName() + "' has been deployed from file : " + fileName));
                return tm.getName();
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Template Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template update from file : " + fileName + " has started"));
        }
        try {
            Mediator mediator;
            OMElement element = artifactConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
            if (element != null) {
                TemplateFactory templateFactory = new TemplateFactory();
                Template tm = templateFactory.createEndpointTemplate(artifactConfig, properties);
                tm.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint Template named '" + tm.getName() + "' has been built from the file " + fileName));
                }
                Template existingSt = this.getSynapseConfiguration().getEndpointTemplate(existingArtifactName);
                if (existingArtifactName.equals(tm.getName())) {
                    this.getSynapseConfiguration().updateEndpointTemplate(tm.getName(), tm);
                } else {
                    this.getSynapseConfiguration().addEndpointTemplate(tm.getName(), tm);
                    this.getSynapseConfiguration().removeEndpointTemplate(existingSt.getName());
                    log.info((Object)("Template: " + existingArtifactName + " has been undeployed"));
                }
                log.info((Object)("Template: " + tm.getName() + " has been updated from the file: " + fileName));
                return tm.getName();
            }
            element = artifactConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"));
            if (element != null && (mediator = MediatorFactoryFinder.getInstance().getMediator(artifactConfig, properties)) instanceof TemplateMediator) {
                TemplateMediator tm = (TemplateMediator)mediator;
                tm.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sequence Template named '" + tm.getName() + "' has been built from the file " + fileName));
                }
                tm.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the Template : " + tm.getName()));
                }
                TemplateMediator existingSt = this.getSynapseConfiguration().getSequenceTemplate(existingArtifactName);
                if (existingArtifactName.equals(tm.getName())) {
                    this.getSynapseConfiguration().updateSequenceTemplate(tm.getName(), tm);
                } else {
                    this.getSynapseConfiguration().addSequenceTemplate(tm.getName(), tm);
                    this.getSynapseConfiguration().removeSequenceTemplate(existingSt.getName());
                    log.info((Object)("Template: " + existingArtifactName + " has been undeployed"));
                }
                existingSt.destroy();
                log.info((Object)("Template: " + tm.getName() + " has been updated from the file: " + fileName));
                return tm.getName();
            }
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the Template from the file: " + fileName);
        }
        return null;
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template Undeployment of the Template named : " + artifactName + " : Started"));
        }
        try {
            Template st = null;
            try {
                st = this.getSynapseConfiguration().getEndpointTemplate(artifactName);
            }
            catch (SynapseException e) {
                if (e.getMessage().indexOf("Cannot locate an either local or remote entry for key") != -1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Undeploying template is not of endpoint type. Undeployer will now check for sequence template for the key: " + artifactName));
                    }
                }
                throw e;
            }
            if (st != null) {
                this.getSynapseConfiguration().removeEndpointTemplate(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroying the Template named : " + artifactName));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Template Undeployment of the template named : " + artifactName + " : Completed"));
                }
                log.info((Object)("Template named '" + st.getName() + "' has been undeployed"));
            } else {
                TemplateMediator tm = this.getSynapseConfiguration().getSequenceTemplate(artifactName);
                if (tm != null) {
                    this.getSynapseConfiguration().removeSequenceTemplate(artifactName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Destroying the Template named : " + artifactName));
                    }
                    tm.destroy();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Template Undeployment of the template named : " + artifactName + " : Completed"));
                    }
                    log.info((Object)("Template named '" + tm.getName() + "' has been undeployed"));
                } else {
                    log.debug((Object)("Template task " + artifactName + " has already been undeployed"));
                }
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Template Undeployment of template named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the Template with name : " + artifactName + " : Started"));
        }
        try {
            Template st = this.getSynapseConfiguration().getEndpointTemplate(artifactName);
            if (st != null) {
                TemplateSerializer ts = new TemplateSerializer();
                OMElement stElem = ts.serializeEndpointTemplate(st, null);
                if (st.getFileName() != null) {
                    String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "templates" + File.separator + st.getFileName();
                    this.writeToFile(stElem, fileName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Restoring the Endpoint Template with name : " + artifactName + " : Completed"));
                    }
                    log.info((Object)("Template named '" + artifactName + "' has been restored"));
                }
            } else {
                TemplateMediator mt = this.getSynapseConfiguration().getSequenceTemplate(artifactName);
                if (mt != null) {
                    TemplateMediatorSerializer ts = new TemplateMediatorSerializer();
                    OMElement stElem = ts.serializeMediator(null, mt);
                    if (mt.getFileName() != null) {
                        String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "templates" + File.separator + mt.getFileName();
                        this.writeToFile(stElem, fileName);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Restoring the Sequence Template with name : " + artifactName + " : Completed"));
                        }
                        log.info((Object)("Template named '" + artifactName + "' has been restored"));
                    }
                } else {
                    this.handleSynapseArtifactDeploymentError("Couldn't restore the Template named '" + artifactName + "', filename cannot be found");
                }
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the Template named '" + artifactName + "' has failed", e);
        }
    }
}

