/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.libraries.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.deployers.SynapseArtifactDeploymentException;

public abstract class ArtifactFile {
    private static final Log log = LogFactory.getLog(ArtifactFile.class);
    protected String fileName;
    protected OMElement configurationElement;
    protected Properties properties;

    public abstract Object build();

    public ArtifactFile(String fileXmlPath) {
        this.fileName = fileXmlPath;
        File f = new File(fileXmlPath);
        if (!f.exists()) {
            throw new SynapseArtifactDeploymentException("file not found at : " + fileXmlPath);
        }
        FileInputStream xmlInputStream = null;
        try {
            xmlInputStream = new FileInputStream(f);
            this.configurationElement = OMXMLBuilderFactory.createOMBuilder((InputStream)xmlInputStream).getDocumentElement();
        }
        catch (FileNotFoundException e) {
            throw new SynapseArtifactDeploymentException("file not found at : " + fileXmlPath);
        }
        catch (OMException e) {
            throw new SynapseArtifactDeploymentException("Error while parsing the artifacts.xml file : " + fileXmlPath, e);
        }
        finally {
            if (xmlInputStream != null) {
                try {
                    ((InputStream)xmlInputStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing input stream for file artifact.", (Throwable)e);
                }
            }
        }
    }

    public OMElement getConfigurationElement() {
        return this.configurationElement;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

