/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.OutputParameters;
import org.apache.sysml.lops.compile.Dag;
import org.apache.sysml.parser.Expression;

public abstract class Lop {
    protected static final Log LOG = LogFactory.getLog((String)Lop.class.getName());
    public static final String FILE_SEPARATOR = "/";
    public static final String PROCESS_PREFIX = "_p";
    public static final String CP_ROOT_THREAD_ID = "_t0";
    public static final String CP_CHILD_THREAD = "_t";
    public static final String INSTRUCTION_DELIMITOR = "\u2021";
    public static final String OPERAND_DELIMITOR = "\u00b0";
    public static final String VALUETYPE_PREFIX = "\u00b7";
    public static final String DATATYPE_PREFIX = "\u00b7";
    public static final String LITERAL_PREFIX = "\u00b7";
    public static final String VARIABLE_NAME_PLACEHOLDER = "\u00b6";
    public static final String NAME_VALUE_SEPARATOR = "=";
    public static final String MATRIX_VAR_NAME_PREFIX = "_mVar";
    public static final String FRAME_VAR_NAME_PREFIX = "_fVar";
    public static final String SCALAR_VAR_NAME_PREFIX = "_Var";
    public static final String UPDATE_INPLACE_PREFIX = "_uip";
    private boolean[] reachable = null;
    private Expression.DataType _dataType;
    private Expression.ValueType _valueType;
    private VisitStatus _visited = VisitStatus.NOTVISITED;
    protected Type type;
    protected ArrayList<Lop> inputs;
    protected ArrayList<Lop> outputs;
    protected int consumerCount;
    protected OutputParameters outParams = null;
    protected LopProperties lps = null;
    public int _beginLine;
    public int _beginColumn;
    public int _endLine;
    public int _endColumn;
    public String _filename;

    public Lop(Type t, Expression.DataType dt, Expression.ValueType vt) {
        this.type = t;
        this._dataType = dt;
        this._valueType = vt;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.outParams = new OutputParameters();
        this.lps = new LopProperties();
    }

    public VisitStatus getVisited() {
        return this._visited;
    }

    public void setVisited(VisitStatus visited) {
        this._visited = visited;
    }

    public boolean[] getReachable() {
        return this.reachable;
    }

    public boolean[] createReachable(int size) {
        this.reachable = new boolean[size];
        return this.reachable;
    }

    public Expression.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(Expression.DataType dt) {
        this._dataType = dt;
    }

    public Expression.ValueType getValueType() {
        return this._valueType;
    }

    public void setValueType(Expression.ValueType vt) {
        this._valueType = vt;
    }

    public Type getType() {
        return this.type;
    }

    public ArrayList<Lop> getInputs() {
        return this.inputs;
    }

    public ArrayList<Lop> getOutputs() {
        return this.outputs;
    }

    public void addInput(Lop op) {
        this.inputs.add(op);
    }

    public void addOutput(Lop op) {
        this.outputs.add(op);
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(int cc) {
        this.consumerCount = cc;
    }

    public int removeConsumer() {
        --this.consumerCount;
        return this.consumerCount;
    }

    public abstract String toString();

    public void resetVisitStatus() {
        if (this.getVisited() == VisitStatus.NOTVISITED) {
            return;
        }
        for (int i = 0; i < this.getInputs().size(); ++i) {
            this.getInputs().get(i).resetVisitStatus();
        }
        this.setVisited(VisitStatus.NOTVISITED);
    }

    public final void printMe() {
        if (LOG.isDebugEnabled()) {
            StringBuilder s = new StringBuilder("");
            if (this.getVisited() != VisitStatus.DONE) {
                int i;
                s.append((Object)((Object)this.getType()) + ": " + this.getID() + "\n");
                s.append("Inputs: ");
                for (i = 0; i < this.getInputs().size(); ++i) {
                    s.append(" " + this.getInputs().get(i).getID() + " ");
                }
                s.append("\n");
                s.append("Outputs: ");
                for (i = 0; i < this.getOutputs().size(); ++i) {
                    s.append(" " + this.getOutputs().get(i).getID() + " ");
                }
                s.append("\n");
                s.append(this.toString());
                s.append("Begin Line: " + this._beginLine + ", Begin Column: " + this._beginColumn + ", End Line: " + this._endLine + ", End Column: " + this._endColumn + "\n");
                s.append("FORMAT:" + (Object)((Object)this.getOutputParameters().getFormat()) + ", rows=" + this.getOutputParameters().getNumRows() + ", cols=" + this.getOutputParameters().getNumCols() + ", Blocked?: " + this.getOutputParameters().isBlocked() + ", rowsInBlock=" + this.getOutputParameters().getRowsInBlock() + ", colsInBlock=" + this.getOutputParameters().getColsInBlock() + "\n");
                this.setVisited(VisitStatus.DONE);
                s.append("\n");
                for (i = 0; i < this.getInputs().size(); ++i) {
                    this.getInputs().get(i).printMe();
                }
            }
            LOG.debug((Object)s.toString());
        }
    }

    public long getID() {
        return this.lps.getID();
    }

    public int getLevel() {
        return this.lps.getLevel();
    }

    protected void setLevel() {
        this.lps.setLevel(this.inputs);
    }

    protected void updateLevel(int newLevel) {
        if (newLevel < this.getLevel()) {
            throw new RuntimeException("Decrement the levels not supported.");
        }
        if (newLevel > this.getLevel()) {
            this.lps.setLevel(newLevel);
            for (Lop out : this.outputs) {
                if (out.getLevel() >= newLevel + 1) continue;
                out.updateLevel(newLevel + 1);
            }
        }
    }

    public LopProperties.ExecLocation getExecLocation() {
        return this.lps.getExecLocation();
    }

    public LopProperties.ExecType getExecType() {
        return this.lps.getExecType();
    }

    public int getCompatibleJobs() {
        return this.lps.getCompatibleJobs();
    }

    public boolean getBreaksAlignment() {
        return this.lps.getBreaksAlignment();
    }

    public boolean getProducesIntermediateOutput() {
        return this.lps.getProducesIntermediateOutput();
    }

    public boolean isAligner() {
        return this.lps.isAligner();
    }

    public boolean definesMRJob() {
        return this.lps.getDefinesMRJob();
    }

    public final void addToDag(Dag<Lop> dag) {
        if (dag.addNode(this)) {
            for (Lop l : this.getInputs()) {
                l.addToDag(dag);
            }
        }
    }

    public OutputParameters getOutputParameters() {
        return this.outParams;
    }

    public String getInstructions(String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String input6, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String input6, String input7, String output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String[] inputs, String outputs) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(int output_index) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass. Lop Type: " + (Object)((Object)this.getType()));
    }

    public String getInstructions(int input_index, int output_index) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass. Lop Type: " + (Object)((Object)this.getType()));
    }

    public String getInstructions(int input_index1, int input_index2, int output_index) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(int input_index1, int input_index2, int input_index3, int output_index) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int output_index) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int input_index5, int output_index) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions(String[] inputs, String[] outputs) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public String getInstructions() {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public SimpleInstType getSimpleInstructionType() {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    public void setFilename(String passed) {
        this._filename = passed;
    }

    public void setAllPositions(String filename, int blp, int bcp, int elp, int ecp) {
        this._filename = filename;
        this._beginLine = blp;
        this._beginColumn = bcp;
        this._endLine = elp;
        this._endColumn = ecp;
    }

    public int getBeginLine() {
        return this._beginLine;
    }

    public int getBeginColumn() {
        return this._beginColumn;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public String getFilename() {
        return this._filename;
    }

    public String printErrorLocation() {
        return "ERROR: line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public String getInstructions(int input, int rowl, int rowu, int coll, int colu, int leftRowDim, int leftColDim, int output) {
        throw new LopsException(this.printErrorLocation() + "Should never be invoked in Baseclass");
    }

    public boolean isVariable() {
        return this.getExecLocation() == LopProperties.ExecLocation.Data && !((Data)this).isLiteral() || this.getExecLocation() != LopProperties.ExecLocation.Data;
    }

    public String prepOperand(String label, Expression.DataType dt, Expression.ValueType vt) {
        StringBuilder sb = new StringBuilder();
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)dt);
        sb.append("\u00b7");
        sb.append((Object)vt);
        return sb.toString();
    }

    public String prepOperand(String label, Expression.DataType dt, Expression.ValueType vt, boolean literal) {
        StringBuilder sb = new StringBuilder();
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)dt);
        sb.append("\u00b7");
        sb.append((Object)vt);
        sb.append("\u00b7");
        sb.append(literal);
        return sb.toString();
    }

    private String prepOperand(String label) {
        StringBuilder sb = new StringBuilder("");
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        return sb.toString();
    }

    public String prepOutputOperand() {
        return this.prepOperand(this.getOutputParameters().getLabel());
    }

    public String prepOutputOperand(int index) {
        return this.prepOperand(String.valueOf(index));
    }

    public String prepOutputOperand(String label) {
        return this.prepOperand(label);
    }

    public String prepScalarLabel() {
        String ret = this.getOutputParameters().getLabel();
        if (this.isVariable()) {
            ret = VARIABLE_NAME_PLACEHOLDER + ret + VARIABLE_NAME_PLACEHOLDER;
        }
        return ret;
    }

    public String prepScalarOperand(LopProperties.ExecType et, String label) {
        boolean isData = this.getExecLocation() == LopProperties.ExecLocation.Data;
        boolean isLiteral = isData && ((Data)this).isLiteral();
        StringBuilder sb = new StringBuilder("");
        if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.SPARK || et == LopProperties.ExecType.GPU || isData && isLiteral) {
            sb.append(label);
        } else {
            sb.append(VARIABLE_NAME_PLACEHOLDER);
            sb.append(label);
            sb.append(VARIABLE_NAME_PLACEHOLDER);
        }
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        sb.append("\u00b7");
        sb.append(isLiteral);
        return sb.toString();
    }

    public String prepScalarInputOperand(LopProperties.ExecType et) {
        return this.prepScalarOperand(et, this.getOutputParameters().getLabel());
    }

    public String prepScalarInputOperand(String label) {
        boolean isData = this.getExecLocation() == LopProperties.ExecLocation.Data;
        boolean isLiteral = isData && ((Data)this).isLiteral();
        StringBuilder sb = new StringBuilder("");
        sb.append(label);
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        sb.append("\u00b7");
        sb.append(isLiteral);
        return sb.toString();
    }

    public String prepInputOperand(int index) {
        return this.prepInputOperand(String.valueOf(index));
    }

    public String prepInputOperand(String label) {
        Expression.DataType dt = this.getDataType();
        if (dt == Expression.DataType.MATRIX) {
            return this.prepOperand(label);
        }
        return this.prepScalarInputOperand(label);
    }

    public boolean usesDistributedCache() {
        return false;
    }

    public int[] distributedCacheInputIndex() {
        return new int[]{-1};
    }

    public boolean hasNonBlockedInputs() {
        for (Lop in : this.getInputs()) {
            if (in.getDataType() != Expression.DataType.MATRIX || in.getOutputParameters().isBlocked()) continue;
            return true;
        }
        return false;
    }

    public static enum VisitStatus {
        DONE,
        NOTVISITED;

    }

    public static enum SimpleInstType {
        Scalar;

    }

    public static enum Type {
        Data,
        DataGen,
        ReBlock,
        CSVReBlock,
        MMCJ,
        MMRJ,
        MMTSJ,
        PMMJ,
        MapMult,
        MapMultChain,
        UnaryCP,
        UNARY,
        BinaryCP,
        Binary,
        Ternary,
        Nary,
        RightIndex,
        LeftIndex,
        ZeroOut,
        Aggregate,
        PartialAggregate,
        BinUaggChain,
        UaggOuterChain,
        TernaryAggregate,
        Grouping,
        Append,
        CombineUnary,
        CombineBinary,
        CombineTernary,
        CentralMoment,
        CoVariance,
        GroupedAgg,
        GroupedAggM,
        Transform,
        DataPartition,
        RepMat,
        ParameterizedBuiltin,
        FunctionCallCP,
        FunctionCallCPSingle,
        CumulativePartialAggregate,
        CumulativeSplitAggregate,
        CumulativeOffsetBinary,
        WeightedSquaredLoss,
        WeightedSigmoid,
        WeightedDivMM,
        WeightedCeMM,
        WeightedUMM,
        SortKeys,
        PickValues,
        Ctable,
        Checkpoint,
        PlusMult,
        MinusMult,
        SpoofFused;

    }
}

