/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;

public class DynamicProjectMatrixCP
extends PackageFunction {
    private static final long serialVersionUID = 1L;
    private static final String OUTPUT_FILE = "DynProjectMatrixWrapperOutput2D";
    private Matrix _ret;

    @Override
    public int getNumFunctionOutputs() {
        return 1;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        return this._ret;
    }

    @Override
    public void execute() {
        try {
            Matrix mD = (Matrix)this.getFunctionInput(0);
            Matrix mC = (Matrix)this.getFunctionInput(1);
            MatrixBlock mbD = (MatrixBlock)mD.getMatrixObject().acquireRead();
            MatrixBlock mbC = (MatrixBlock)mC.getMatrixObject().acquireRead();
            int rows = mbC.getNumColumns();
            int cols = mbC.getNumColumns();
            String dir = this.createOutputFilePathAndName(OUTPUT_FILE);
            MatrixBlock mb = null;
            if (mbD.getNumColumns() == 1) {
                cols = 1;
                mb = new MatrixBlock(rows, cols, false);
                for (int i = 0; i < rows; ++i) {
                    int ix1 = (int)mbC.quickGetValue(0, i) - 1;
                    double val = mbD.quickGetValue(ix1, 0);
                    mb.quickSetValue(i, 0, val);
                }
            } else {
                mb = new MatrixBlock(rows, cols, false);
                for (int i = 0; i < rows; ++i) {
                    int ix1 = (int)mbC.quickGetValue(0, i) - 1;
                    for (int j = 0; j < cols; ++j) {
                        int ix2 = (int)mbC.quickGetValue(0, j) - 1;
                        double val = mbD.quickGetValue(ix1, ix2);
                        mb.quickSetValue(i, j, val);
                    }
                }
            }
            this._ret = new Matrix(dir, rows, cols, Matrix.ValueType.Double);
            this._ret.setMatrixDoubleArray(mb, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
            mD.getMatrixObject().release();
            mC.getMatrixObject().release();
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing dynamic project of matrix", e);
        }
    }
}

