/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;

public class RewriteInjectSparkPReadCheckpointing
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (!OptimizerUtils.isSparkExecutionMode()) {
            return roots;
        }
        if (roots == null) {
            return null;
        }
        for (Hop h : roots) {
            this.rInjectCheckpointAfterPRead(h);
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        return root;
    }

    private void rInjectCheckpointAfterPRead(Hop hop) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD || hop.requiresReblock()) {
            hop.setRequiresCheckpoint(true);
        } else if (hop.getInput() != null) {
            for (int i = 0; i < hop.getInput().size(); ++i) {
                this.rInjectCheckpointAfterPRead(hop.getInput().get(i));
            }
        }
        hop.setVisited();
    }
}

