/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.decode;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.decode.Decoder;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DecoderDummycode
extends Decoder {
    private static final long serialVersionUID = 4758831042891032129L;
    private int[] _clPos = null;
    private int[] _cuPos = null;

    protected DecoderDummycode(Expression.ValueType[] schema, int[] dcCols) {
        super(schema, dcCols);
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        out.ensureAllocatedColumns(in.getNumRows());
        for (int i = 0; i < in.getNumRows(); ++i) {
            for (int j = 0; j < this._colList.length; ++j) {
                for (int k = this._clPos[j]; k < this._cuPos[j]; ++k) {
                    if (in.quickGetValue(i, k - 1) == 0.0) continue;
                    int col = this._colList[j] - 1;
                    out.set(i, col, UtilFunctions.doubleToObject(out.getSchema()[col], k - this._clPos[j] + 1));
                }
            }
        }
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._clPos = new int[this._colList.length];
        this._cuPos = new int[this._colList.length];
        int off = 0;
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int ndist = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._clPos[j] = off + colID;
            this._cuPos[j] = this._clPos[j] + ndist;
            off += ndist - 1;
        }
    }
}

