/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Tagged;

public class TaggedMatrixIndexes
extends Tagged<MatrixIndexes> {
    public TaggedMatrixIndexes() {
    }

    public TaggedMatrixIndexes(MatrixIndexes ix, byte t) {
        super(ix, t);
    }

    public TaggedMatrixIndexes(TaggedMatrixIndexes that) {
        this.tag = that.tag;
        this.base = that.base;
    }

    @Override
    public String toString() {
        return "k: " + this.base + ", tag: " + this.tag;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        if (this.base == null) {
            this.base = new MatrixIndexes();
        }
        ((MatrixIndexes)this.base).readFields(in);
        this.tag = in.readByte();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        ((MatrixIndexes)this.base).write(out);
        out.writeByte(this.tag);
    }

    @Override
    public int compareTo(TaggedMatrixIndexes other) {
        int tmp = ((MatrixIndexes)this.base).compareTo((MatrixIndexes)other.base);
        if (tmp != 0) {
            return tmp;
        }
        if (this.tag != other.tag) {
            return this.tag - other.tag;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TaggedMatrixIndexes)) {
            return false;
        }
        TaggedMatrixIndexes tother = (TaggedMatrixIndexes)other;
        return ((MatrixIndexes)this.base).equals(tother.base) && this.tag == tother.tag;
    }

    @Override
    public int hashCode() {
        return ((MatrixIndexes)this.base).hashCode() + this.tag;
    }
}

