/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.yarn;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.yarn.DMLYarnClient;
import org.apache.sysml.yarn.DMLYarnClientProxy;
import org.apache.sysml.yarn.ropt.ResourceConfig;
import org.apache.sysml.yarn.ropt.ResourceOptimizer;
import org.apache.sysml.yarn.ropt.YarnClusterConfig;

public class DMLAppMasterUtils {
    private static ResourceConfig _rc = null;
    private static HashMap<ProgramBlock, Long> _rcMap = null;

    public static String constructHDFSWorkingDir(DMLConfig conf, ApplicationId appId) {
        StringBuilder sb = new StringBuilder();
        sb.append(conf.getTextValue("sysml.scratch"));
        sb.append("/");
        sb.append(appId);
        sb.append("/");
        return sb.toString();
    }

    public static void setupConfigRemoteMaxMemory(DMLConfig conf) {
        if (DMLScript.isActiveAM()) {
            CompilerConfig cconf = OptimizerUtils.constructCompilerConfig(conf);
            ConfigurationManager.setGlobalConfig(cconf);
            if (DMLAppMasterUtils.isResourceOptimizerEnabled()) {
                ResourceConfig rc;
                InfrastructureAnalyzer.getRemoteMaxMemoryMap();
                String memStr = conf.getTextValue("sysml.yarn.mapreduce.mem");
                _rc = rc = ResourceConfig.deserialize(memStr);
            } else if (conf.getIntValue("sysml.yarn.mapreduce.mem") > 0) {
                InfrastructureAnalyzer.getRemoteMaxMemoryMap();
                long mem = (long)conf.getIntValue("sysml.yarn.mapreduce.mem") * 1024L * 1024L;
                InfrastructureAnalyzer.setRemoteMaxMemoryMap(mem);
                InfrastructureAnalyzer.setRemoteMaxMemoryReduce(mem);
            }
        }
    }

    public static void setupProgramMappingRemoteMaxMemory(Program prog) {
        if (DMLScript.isActiveAM() && DMLAppMasterUtils.isResourceOptimizerEnabled()) {
            ArrayList<ProgramBlock> pbProg = DMLAppMasterUtils.getRuntimeProgramBlocks(prog);
            ArrayList<ProgramBlock> B = ResourceOptimizer.compileProgram(pbProg, _rc);
            _rcMap = new HashMap();
            for (int i = 0; i < B.size(); ++i) {
                _rcMap.put(B.get(i), _rc.getMRResources(i));
            }
        }
    }

    public static void setupProgramBlockRemoteMaxMemory(ProgramBlock pb) {
        if (DMLScript.isActiveAM() && DMLAppMasterUtils.isResourceOptimizerEnabled() && _rcMap != null && _rcMap.containsKey(pb)) {
            long mem = _rcMap.get(pb);
            InfrastructureAnalyzer.setRemoteMaxMemoryMap(mem);
            InfrastructureAnalyzer.setRemoteMaxMemoryReduce(mem);
            OptimizerUtils.resetDefaultSize();
        }
    }

    public static void setupMRJobRemoteMaxMemory(JobConf job, DMLConfig conf) {
        if (DMLScript.isActiveAM() && conf.getBooleanValue("sysml.yarn.appmaster")) {
            int memMB = -1;
            memMB = DMLAppMasterUtils.isResourceOptimizerEnabled() ? (int)(InfrastructureAnalyzer.getRemoteMaxMemoryMap() / 0x100000L) : conf.getIntValue("sysml.yarn.mapreduce.mem");
            if (memMB > 0) {
                String memOpts = "-Xmx" + memMB + "m -Xms" + memMB + "m -Xmn" + memMB / 10 + "m";
                job.set(MRConfigurationNames.MR_MAP_JAVA_OPTS, memOpts);
                job.set(MRConfigurationNames.MR_MAP_MEMORY_MB, String.valueOf(DMLYarnClient.computeMemoryAllocation(memMB)));
                job.set(MRConfigurationNames.MR_REDUCE_JAVA_OPTS, memOpts);
                job.set(MRConfigurationNames.MR_REDUCE_MEMORY_MB, String.valueOf(DMLYarnClient.computeMemoryAllocation(memMB)));
            }
        }
    }

    public static boolean isResourceOptimizerEnabled() {
        return DMLYarnClientProxy.RESOURCE_OPTIMIZER || OptimizerUtils.isOptLevel(OptimizerUtils.OptimizationLevel.O3_LOCAL_RESOURCE_TIME_MEMORY);
    }

    protected static ArrayList<ProgramBlock> getRuntimeProgramBlocks(Program prog) {
        ArrayList<ProgramBlock> ret = new ArrayList<ProgramBlock>();
        ret.addAll(prog.getProgramBlocks());
        ret.addAll(prog.getFunctionProgramBlocks().values());
        return ret;
    }

    protected static void setupRemoteParallelTasks(YarnClusterConfig cc) {
        int pmap = (int)cc.getNumCores();
        int preduce = (int)cc.getNumCores() / 2;
        InfrastructureAnalyzer.setRemoteParallelMapTasks(pmap);
        InfrastructureAnalyzer.setRemoteParallelReduceTasks(preduce);
    }
}

