/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.LinearAlgebraUtils;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupDDC1
extends ColGroupDDC {
    private static final long serialVersionUID = 5204955589230760157L;
    private byte[] _data;

    protected ColGroupDDC1() {
    }

    protected ColGroupDDC1(int[] colIndices, int numRows, ABitmap ubm, CompressionSettings cs) {
        super(colIndices, numRows, ubm, cs);
        int numVals = ubm.getNumValues();
        int numCols = ubm.getNumColumns();
        this._data = new byte[numRows];
        if (ubm.getNumOffsets() < (long)numRows * (long)numCols) {
            int zeroIx = this.containsAllZeroValue();
            if (zeroIx < 0) {
                zeroIx = numVals;
            }
            Arrays.fill(this._data, (byte)zeroIx);
            this._zeros = true;
        }
        for (int i = 0; i < numVals; ++i) {
            int[] tmpList = ubm.getOffsetsList(i).extractValues();
            int tmpListSize = ubm.getNumOffsets(i);
            for (int k = 0; k < tmpListSize; ++k) {
                this._data[tmpList[k]] = (byte)i;
            }
        }
    }

    protected ColGroupDDC1(int[] colIndices, int numRows, ADictionary dict, byte[] data, boolean zeros) {
        super(colIndices, numRows, dict);
        this._data = data;
        this._zeros = zeros;
    }

    @Override
    protected ColGroup.ColGroupType getColGroupType() {
        return ColGroup.ColGroupType.DDC1;
    }

    public byte[] getData() {
        return this._data;
    }

    @Override
    public void rightMultByVector(double[] b, double[] c, int rl, int ru, double[] dictVals) {
        int numVals = this.getNumValues();
        double[] vals = this.preaggValues(numVals, b, dictVals);
        LinearAlgebraUtils.vectListAdd(vals, c, this._data, rl, ru);
    }

    @Override
    protected int getIndex(int r) {
        return this._data[r] & 0xFF;
    }

    @Override
    protected int getIndex(int r, int colIx) {
        return this._data[r] & 255 * this.getNumCols() + colIx;
    }

    @Override
    protected double getData(int r, double[] values) {
        int index = this._data[r] & 0xFF;
        return index == values.length ? 0.0 : values[index];
    }

    @Override
    protected double getData(int r, int colIx, double[] values) {
        int index = (this._data[r] & 0xFF) * this.getNumCols() + colIx;
        return index == values.length ? 0.0 : values[index];
    }

    @Override
    protected void setData(int r, int code) {
        this._data[r] = (byte)code;
    }

    public void recodeData(HashMap<Double, Integer> map) {
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        byte[] lookup = new byte[numVals];
        for (int k = 0; k < numVals; ++k) {
            lookup[k] = map.get(values[k]).byteValue();
        }
        for (int i = 0; i < this._numRows; ++i) {
            this._data[i] = lookup[this._data[i] & 0xFF];
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        for (int i = 0; i < this._numRows; ++i) {
            out.writeByte(this._data[i]);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._data = new byte[this._numRows];
        for (int i = 0; i < this._numRows; ++i) {
            this._data[i] = in.readByte();
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += (long)this._data.length;
    }

    @Override
    public long estimateInMemorySize() {
        return ColGroupSizes.estimateInMemorySizeDDC1(this.getNumCols(), this.getNumValues(), this._data.length, this.isLossy());
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupDDC1(this._colIndexes, this._numRows, this.applyScalarOp(op), this._data, this._zeros);
        }
        return new ColGroupDDC1(this._colIndexes, this._numRows, this.applyScalarOp(op, val0, this._colIndexes.length), this._data, false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" DataLength: " + this._data.length);
        return sb.toString();
    }
}

