/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.FileFormatPropertiesMM;
import org.apache.sysds.runtime.util.UtilFunctions;

public class IOUtilFunctions {
    private static final Log LOG = LogFactory.getLog((String)UtilFunctions.class.getName());
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    public static final String EMPTY_TEXT_LINE = "0 0 0\n";
    private static final char CSV_QUOTE_CHAR = '\"';
    public static final String LIBSVM_DELIM = " ";
    public static final String LIBSVM_INDEX_DELIM = ":";

    public static FileSystem getFileSystem(String fname) throws IOException {
        return IOUtilFunctions.getFileSystem(new Path(fname), (Configuration)ConfigurationManager.getCachedJobConf());
    }

    public static FileSystem getFileSystem(Path fname) throws IOException {
        return IOUtilFunctions.getFileSystem(fname, (Configuration)ConfigurationManager.getCachedJobConf());
    }

    public static FileSystem getFileSystem(Configuration conf) throws IOException {
        try {
            return FileSystem.get((Configuration)conf);
        }
        catch (NoClassDefFoundError err) {
            throw new IOException(err.getMessage());
        }
    }

    public static FileSystem getFileSystem(Path fname, Configuration conf) throws IOException {
        try {
            return FileSystem.get((URI)fname.toUri(), (Configuration)conf);
        }
        catch (NoClassDefFoundError err) {
            throw new IOException(err.getMessage());
        }
    }

    public static boolean isSameFileScheme(Path path1, Path path2) {
        if (path1 == null || path2 == null || path1.toUri() == null || path2.toUri() == null) {
            return false;
        }
        String scheme1 = path1.toUri().getScheme();
        String scheme2 = path2.toUri().getScheme();
        return scheme1 == null && scheme2 == null || scheme1 != null && scheme1.equals(scheme2);
    }

    public static boolean isObjectStoreFileScheme(Path path) {
        if (path == null || path.toUri() == null || path.toUri().getScheme() == null) {
            return false;
        }
        String scheme = path.toUri().getScheme();
        return scheme.startsWith("s3") || scheme.startsWith("swift");
    }

    public static String getPartFileName(int pos) {
        return String.format("0-m-%05d", pos);
    }

    public static void closeSilently(Closeable io) {
        try {
            if (io != null) {
                io.close();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to close IO resource.", (Throwable)ex);
        }
    }

    public static void closeSilently(RecordReader<?, ?> rr) {
        try {
            if (rr != null) {
                rr.close();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to close record reader.", (Throwable)ex);
        }
    }

    public static void checkAndRaiseErrorCSVEmptyField(String row, boolean fill, boolean emptyFound) throws IOException {
        if (!fill && emptyFound) {
            throw new IOException("Empty fields found in delimited file. Use \"fill\" option to read delimited files with empty fields:" + (row != null ? row : ""));
        }
    }

    public static void checkAndRaiseErrorCSVNumColumns(String fname, String line, String[] parts, long ncol) throws IOException {
        int realncol = parts.length;
        if ((long)realncol != ncol) {
            throw new IOException("Invalid number of columns (" + realncol + ", expected=" + ncol + ") found in delimited file (" + fname + ") for line: " + line);
        }
    }

    public static String[] split(String str, String delim) {
        return StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)delim);
    }

    public static String[] splitCSV(String str, String delim) {
        if (str == null || str.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int from = 0;
        int to = 0;
        int len = str.length();
        int dlen = delim.length();
        while (from < len) {
            if (str.charAt(from) == '\"' && str.indexOf(34, from + 1) > 0) {
                to = str.indexOf(34, from + 1);
                while (to + 1 < len && str.charAt(to + 1) == '\"') {
                    to = str.indexOf(34, to + 2);
                }
                if (++to < len - 1 && !str.regionMatches(to, delim, 0, dlen)) {
                    to = str.indexOf(delim, to + 1);
                }
            } else {
                to = str.regionMatches(from, delim, 0, dlen) ? from : str.indexOf(delim, from + 1);
            }
            to = to >= 0 ? to : len;
            tokens.add(str.substring(from, to));
            from = to + delim.length();
        }
        if (from == len) {
            tokens.add("");
        }
        return tokens.toArray(new String[0]);
    }

    public static String[] splitCSV(String str, String delim, String[] tokens, Set<String> naStrings) {
        if (str == null || str.isEmpty()) {
            return new String[]{""};
        }
        int from = 0;
        int to = 0;
        int len = str.length();
        int dlen = delim.length();
        int pos = 0;
        while (from < len) {
            if (str.charAt(from) == '\"' && str.indexOf(34, from + 1) > 0) {
                to = str.indexOf(34, from + 1);
                while (to + 1 < len && str.charAt(to + 1) == '\"') {
                    to = str.indexOf(34, to + 2);
                }
                if (++to < len - 1 && !str.regionMatches(to, delim, 0, dlen)) {
                    to = str.indexOf(delim, to + 1);
                }
            } else {
                to = str.regionMatches(from, delim, 0, dlen) ? from : str.indexOf(delim, from + 1);
            }
            to = to >= 0 ? to : len;
            String curString = str.substring(from, to);
            tokens[pos++] = naStrings.contains(curString) ? null : curString;
            from = to + delim.length();
        }
        if (from == len) {
            tokens[pos] = "";
        }
        return tokens;
    }

    public static int countTokensCSV(String str, String delim) {
        if (str == null || str.isEmpty()) {
            return 1;
        }
        int numTokens = 0;
        int from = 0;
        int to = 0;
        int len = str.length();
        int dlen = delim.length();
        while (from < len) {
            if (str.charAt(from) == '\"' && str.indexOf(34, from + 1) > 0) {
                to = str.indexOf(34, from + 1);
                while (to + 1 < len && str.charAt(to + 1) == '\"') {
                    to = str.indexOf(34, to + 2);
                }
                if (++to < len - 1 && !str.regionMatches(to, delim, 0, dlen)) {
                    to = str.indexOf(delim, to + 1);
                }
            } else {
                to = str.regionMatches(from, delim, 0, dlen) ? from : str.indexOf(delim, from + 1);
            }
            to = to >= 0 ? to : len;
            from = to + delim.length();
            ++numTokens;
        }
        if (from == len) {
            ++numTokens;
        }
        return numTokens;
    }

    public static String[] splitByFirst(String str, String delim) {
        int pos = str.indexOf(delim);
        return new String[]{str.substring(0, pos), str.substring(pos + 1, str.length())};
    }

    public static FileFormatPropertiesMM readAndParseMatrixMarketHeader(String filename) throws DMLRuntimeException {
        String[] header = IOUtilFunctions.readMatrixMarketHeader(filename);
        return FileFormatPropertiesMM.parse(header[0]);
    }

    public static String[] readMatrixMarketHeader(String filename) {
        String[] retVal;
        block18: {
            retVal = new String[]{new String(""), new String("")};
            boolean exists = false;
            try {
                Path path = new Path(filename);
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                exists = fs.exists(path);
                boolean getFileStatusIsDir = fs.getFileStatus(path).isDirectory();
                if (exists && getFileStatusIsDir) {
                    throw new DMLRuntimeException("MatrixMarket files as directories not supported");
                }
                if (exists) {
                    try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
                        retVal[0] = in.readLine();
                        do {
                            retVal[1] = in.readLine();
                        } while (retVal[1].charAt(0) == '%');
                        if (!retVal[0].startsWith("%%")) {
                            throw new DMLRuntimeException("MatrixMarket files must begin with a header line.");
                        }
                        break block18;
                    }
                }
                throw new DMLRuntimeException("Could not find the file: " + filename);
            }
            catch (IOException e) {
                throw new DMLRuntimeException(e);
            }
        }
        return retVal;
    }

    public static int countNnz(String[] cols) {
        return IOUtilFunctions.countNnz(cols, 0, cols.length);
    }

    public static int countNnz(String[] cols, int pos, int len) {
        int lnnz = 0;
        for (int i = pos; i < pos + len; ++i) {
            String col = cols[i];
            lnnz += !col.isEmpty() && !col.equals("0") && !col.equals("0.0") ? 1 : 0;
        }
        return lnnz;
    }

    public static int getUTFSize(String value) {
        if (value == null) {
            return 2;
        }
        int size = 2;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            size += c >= '\u0001' && c <= '\u007f' ? 1 : (c >= '\u0800' ? 3 : 2);
        }
        return size;
    }

    public static InputStream toInputStream(String input) {
        if (input == null) {
            return null;
        }
        return new ReaderInputStream((Reader)new StringReader(input), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[8192];
            int len = 0;
            while ((len = input.read(buff)) != -1) {
                bos.write(buff, 0, len);
            }
            String string = bos.toString("UTF-8");
            return string;
        }
        finally {
            IOUtilFunctions.closeSilently(input);
        }
    }

    public static InputSplit[] sortInputSplits(InputSplit[] splits) {
        if (splits[0] instanceof FileSplit) {
            Arrays.sort(splits, new Comparator<InputSplit>(){

                @Override
                public int compare(InputSplit o1, InputSplit o2) {
                    Path p1 = ((FileSplit)o1).getPath();
                    Path p2 = ((FileSplit)o2).getPath();
                    return p1.toString().compareTo(p2.toString());
                }
            });
        }
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countNumColumnsCSV(InputSplit[] splits, InputFormat informat, JobConf job, String delim) throws IOException {
        LongWritable key = new LongWritable();
        Text value = new Text();
        int ncol = -1;
        for (int i = 0; i < splits.length && ncol <= 0; ++i) {
            RecordReader reader = informat.getRecordReader(splits[i], job, Reporter.NULL);
            try {
                if (!reader.next((Object)key, (Object)value)) continue;
                boolean hasValue = true;
                if (value.toString().startsWith("#Meta\u00b7MV")) {
                    hasValue = reader.next((Object)key, (Object)value);
                }
                if (value.toString().startsWith("#Meta\u00b7ND")) {
                    hasValue = reader.next((Object)key, (Object)value);
                }
                String row = value.toString().trim();
                if (!hasValue || row.isEmpty()) continue;
                ncol = IOUtilFunctions.countTokensCSV(row, delim);
                continue;
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
        }
        return ncol;
    }

    public static Path[] getSequenceFilePaths(FileSystem fs, Path file) throws IOException {
        Path[] ret = null;
        if (fs.isDirectory(file) || IOUtilFunctions.isObjectStoreFileScheme(file)) {
            FileStatus[] dStatus;
            LinkedList<Path> tmp = new LinkedList<Path>();
            for (FileStatus fdStatus : dStatus = fs.listStatus(file)) {
                if (fdStatus.getPath().getName().startsWith("_") || fdStatus.getPath().toString().equals(file.toString() + ".mtd")) continue;
                tmp.add(fdStatus.getPath());
            }
            ret = tmp.toArray(new Path[0]);
        } else {
            ret = new Path[]{file};
        }
        return ret;
    }

    public static void deleteCrcFilesFromLocalFileSystem(FileSystem fs, Path path) throws IOException {
        if (fs instanceof LocalFileSystem) {
            Path fnameCrc = new Path(path.getParent(), "." + path.getName() + ".crc");
            fs.delete(fnameCrc, false);
            Path fnameMtdCrc = new Path(path.getParent(), "." + path.getName() + ".mtd.crc");
            fs.delete(fnameMtdCrc, false);
        }
    }

    public static int baToShort(byte[] ba, int off) {
        return ((ba[off + 0] & 0xFF) << 8) + ((ba[off + 1] & 0xFF) << 0);
    }

    public static int baToInt(byte[] ba, int off) {
        return ((ba[off + 0] & 0xFF) << 24) + ((ba[off + 1] & 0xFF) << 16) + ((ba[off + 2] & 0xFF) << 8) + ((ba[off + 3] & 0xFF) << 0);
    }

    public static long baToLong(byte[] ba, int off) {
        return ((long)(ba[off + 0] & 0xFF) << 56) + ((long)(ba[off + 1] & 0xFF) << 48) + ((long)(ba[off + 2] & 0xFF) << 40) + ((long)(ba[off + 3] & 0xFF) << 32) + ((long)(ba[off + 4] & 0xFF) << 24) + ((long)(ba[off + 5] & 0xFF) << 16) + ((long)(ba[off + 6] & 0xFF) << 8) + ((long)(ba[off + 7] & 0xFF) << 0);
    }

    public static void shortToBa(int val, byte[] ba, int off) {
        ba[off + 0] = (byte)(val >>> 8 & 0xFF);
        ba[off + 1] = (byte)(val >>> 0 & 0xFF);
    }

    public static void intToBa(int val, byte[] ba, int off) {
        ba[off + 0] = (byte)(val >>> 24 & 0xFF);
        ba[off + 1] = (byte)(val >>> 16 & 0xFF);
        ba[off + 2] = (byte)(val >>> 8 & 0xFF);
        ba[off + 3] = (byte)(val >>> 0 & 0xFF);
    }

    public static void longToBa(long val, byte[] ba, int off) {
        ba[off + 0] = (byte)(val >>> 56 & 0xFFL);
        ba[off + 1] = (byte)(val >>> 48 & 0xFFL);
        ba[off + 2] = (byte)(val >>> 40 & 0xFFL);
        ba[off + 3] = (byte)(val >>> 32 & 0xFFL);
        ba[off + 4] = (byte)(val >>> 24 & 0xFFL);
        ba[off + 5] = (byte)(val >>> 16 & 0xFFL);
        ba[off + 6] = (byte)(val >>> 8 & 0xFFL);
        ba[off + 7] = (byte)(val >>> 0 & 0xFFL);
    }

    public static byte[] getBytes(ByteBuffer buff) {
        int len = buff.limit();
        if (buff.hasArray()) {
            return Arrays.copyOf(buff.array(), len);
        }
        byte[] ret = new byte[len];
        buff.get(ret, buff.position(), len);
        return ret;
    }

    public static <T> T get(Future<T> in) {
        try {
            return in.get();
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    public static class CountRowsTask
    implements Callable<Long> {
        private final InputSplit _split;
        private final TextInputFormat _inputFormat;
        private final JobConf _jobConf;
        private final boolean _hasHeader;

        public CountRowsTask(InputSplit split, TextInputFormat inputFormat, JobConf jobConf) {
            this(split, inputFormat, jobConf, false);
        }

        public CountRowsTask(InputSplit split, TextInputFormat inputFormat, JobConf jobConf, boolean header) {
            this._split = split;
            this._inputFormat = inputFormat;
            this._jobConf = jobConf;
            this._hasHeader = header;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            RecordReader reader = this._inputFormat.getRecordReader(this._split, this._jobConf, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            long nrows = 0L;
            try {
                if (this._hasHeader) {
                    reader.next((Object)key, (Object)value);
                }
                while (reader.next((Object)key, (Object)value)) {
                    ++nrows;
                }
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
            return nrows;
        }
    }
}

