/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.deploy.Command;
import org.apache.spark.internal.Logging;
import org.apache.spark.launcher.WorkerCommandBuilder;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;

public final class CommandUtils$
implements Logging {
    public static CommandUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CommandUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ProcessBuilder buildProcessBuilder(Command command, SecurityManager securityMgr, int memory, String sparkHome, Function1<String, String> substituteArguments, Seq<String> classPaths, Map<String, String> env) {
        Command localCommand = this.buildLocalCommand(command, securityMgr, substituteArguments, classPaths, env);
        Seq<String> commandSeq = this.buildCommandSeq(localCommand, memory, sparkHome);
        ProcessBuilder builder = new ProcessBuilder((String[])commandSeq.toArray(ClassTag$.MODULE$.apply(String.class)));
        java.util.Map<String, String> environment = builder.environment();
        localCommand.environment().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CommandUtils$.$anonfun$buildProcessBuilder$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = environment.put(key, value);
            return string;
        });
        return builder;
    }

    public Seq<String> buildProcessBuilder$default$6() {
        return (Seq)Nil$.MODULE$;
    }

    public Map<String, String> buildProcessBuilder$default$7() {
        return package$.MODULE$.env();
    }

    private Seq<String> buildCommandSeq(Command command, int memory, String sparkHome) {
        java.util.List<String> cmd = new WorkerCommandBuilder(sparkHome, memory, command).buildCommand();
        return ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(cmd).asScala()).$plus$plus((GenTraversableOnce)new .colon.colon((Object)command.mainClass(), (List)Nil$.MODULE$)).$plus$plus(command.arguments()).toSeq();
    }

    private Command buildLocalCommand(Command command, SecurityManager securityMgr, Function1<String, String> substituteArguments, Seq<String> classPath, Map<String, String> env) {
        Map newEnvironment;
        Map map;
        String libraryPathName = Utils$.MODULE$.libraryPathEnvName();
        Seq<String> libraryPathEntries = command.libraryPathEntries();
        Option cmdLibraryPath = command.environment().get((Object)libraryPathName);
        if (libraryPathEntries.nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(libraryPathName)).nonEmpty()) {
            Seq libraryPaths = (Seq)((TraversableLike)libraryPathEntries.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(cmdLibraryPath), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(env.get((Object)libraryPathName)), Seq$.MODULE$.canBuildFrom());
            map = command.environment().$plus(new Tuple2((Object)libraryPathName, (Object)libraryPaths.mkString(File.pathSeparator)));
        } else {
            map = newEnvironment = command.environment();
        }
        if (securityMgr.isAuthenticationEnabled()) {
            newEnvironment = newEnvironment.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecurityManager$.MODULE$.ENV_AUTH_SECRET()), (Object)securityMgr.getSecretKey()));
        }
        return new Command(command.mainClass(), (Seq<String>)((Seq)command.arguments().map(substituteArguments, Seq$.MODULE$.canBuildFrom())), (Map<String, String>)newEnvironment, (Seq<String>)((Seq)command.classPathEntries().$plus$plus(classPath, Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)Nil$.MODULE$), (Seq<String>)((Seq)command.javaOpts().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(new StringBuilder(2).append("-D").append(SecurityManager$.MODULE$.SPARK_AUTH_SECRET_CONF()).toString())))));
    }

    private Seq<String> buildLocalCommand$default$4() {
        return (Seq)Nil$.MODULE$;
    }

    public void redirectStream(InputStream in, File file) {
        FileOutputStream out = new FileOutputStream(file, true);
        new Thread(file, in, out){
            private final InputStream in$1;
            private final FileOutputStream out$1;
            private final File file$1;

            public void run() {
                try {
                    Utils$.MODULE$.copyStream(this.in$1, this.out$1, true, Utils$.MODULE$.copyStream$default$4());
                }
                catch (IOException e) {
                    CommandUtils$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Redirection to ").append($this.file$1).append(" closed: ").append(e.getMessage()).toString());
                }
            }
            {
                this.in$1 = in$1;
                this.out$1 = out$1;
                this.file$1 = file$1;
                super(new StringBuilder(19).append("redirect output to ").append(file$1).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.deploy.worker.CommandUtils$$anon$1 java.io.IOException )}, serializedLambda);
            }
        }.start();
    }

    public static final /* synthetic */ boolean $anonfun$buildProcessBuilder$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private CommandUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

