/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;

public class DependencyTask<E>
implements Comparable<DependencyTask<?>>,
Callable<E> {
    public static final boolean ENABLE_DEBUG_DATA = false;
    protected static final Log LOG = LogFactory.getLog((String)DependencyTask.class.getName());
    private final Callable<E> _task;
    protected final List<DependencyTask<?>> _dependantTasks;
    public List<DependencyTask<?>> _dependencyTasks = null;
    private CompletableFuture<Future<?>> _future;
    private int _rdy = 0;
    private Integer _priority = 0;
    private ExecutorService _pool;

    public DependencyTask(Callable<E> task, List<DependencyTask<?>> dependantTasks) {
        this._dependantTasks = dependantTasks;
        this._task = task;
    }

    public void addPool(ExecutorService pool) {
        this._pool = pool;
    }

    public void assignFuture(CompletableFuture<Future<?>> f) {
        this._future = f;
    }

    public boolean isReady() {
        return this._rdy == 0;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decrease() {
        DependencyTask dependencyTask = this;
        synchronized (dependencyTask) {
            --this._rdy;
            return this.isReady();
        }
    }

    public void addDependent(DependencyTask<?> dependencyTask) {
        this._dependantTasks.add(dependencyTask);
        ++dependencyTask._rdy;
    }

    public boolean hasDependency(DependencyTask<?> dependencyTask) {
        return this._dependantTasks.contains(dependencyTask);
    }

    @Override
    public E call() throws Exception {
        LOG.debug((Object)("Executing Task: " + this));
        long t0 = System.nanoTime();
        E ret = this._task.call();
        LOG.debug((Object)("Finished Task: " + this + " in: " + String.format("%.3f", (double)(System.nanoTime() - t0) * 1.0E-9) + "sec."));
        this._dependantTasks.forEach(t -> {
            if (t.decrease()) {
                if (this._pool == null) {
                    throw new DMLRuntimeException("ExecutorService was not set for DependencyTask");
                }
                t._future.complete(this._pool.submit(t));
            }
        });
        return ret;
    }

    public String toString() {
        return this._task.toString() + "<Prio: " + this._priority + "><Waiting: " + this._dependantTasks.size() + ">";
    }

    @Override
    public int compareTo(DependencyTask<?> task) {
        return -1 * this._priority.compareTo(task._priority);
    }
}

