/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class DDCScheme
implements ICLAScheme {
    private final IColIndex cols;
    private final int nUnique;
    private final DblArrayCountHashMap map;
    private final ADictionary dict;

    private DDCScheme(ColGroupDDC g) {
        this.cols = g.getColIndices();
        this.nUnique = g.getNumValues();
        this.dict = g.getDictionary();
        MatrixBlock mbDict = this.dict.getMBDict(this.cols.size()).getMatrixBlock();
        int dictRows = mbDict.getNumRows();
        int dictCols = mbDict.getNumColumns();
        this.map = new DblArrayCountHashMap(dictRows, dictCols);
        ReaderColumnSelection r = ReaderColumnSelection.createReader(mbDict, ColIndexFactory.create(dictCols), false, 0, dictRows);
        DblArray d = null;
        while ((d = r.nextRow()) != null) {
            this.map.increment(d);
        }
    }

    public static ICLAScheme create(ColGroupDDC g) {
        if (g.getColIndices().size() == 1) {
            return null;
        }
        return new DDCScheme(g);
    }

    @Override
    public AColGroup encode(MatrixBlock data) {
        return this.encode(data, this.cols);
    }

    @Override
    public AColGroup encode(MatrixBlock data, IColIndex columns) {
        DblArray cellVals;
        if (columns.size() != this.cols.size()) {
            throw new IllegalArgumentException("Invalid columns to encode");
        }
        int nRow = data.getNumRows();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, columns, false, 0, nRow);
        AMapToData d = MapToFactory.create(nRow, this.nUnique);
        while ((cellVals = reader.nextRow()) != null) {
            int row = reader.getCurrentRowIndex();
            int id = this.map.getId(cellVals);
            if (id == -1) {
                return null;
            }
            d.set(row, id);
        }
        return ColGroupDDC.create(columns, this.dict, d, null);
    }
}

