/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cocode.CoCodeBinPacking;
import org.apache.sysds.runtime.compress.cocode.CoCodeGreedy;
import org.apache.sysds.runtime.compress.cocode.CoCodeHybrid;
import org.apache.sysds.runtime.compress.cocode.CoCodePriorityQue;
import org.apache.sysds.runtime.compress.cocode.CoCodeStatic;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public interface CoCoderFactory {
    public static final Log LOG = LogFactory.getLog((String)AColumnCoCoder.class.getName());

    public static CompressedSizeInfo findCoCodesByPartitioning(AComEst est, CompressedSizeInfo colInfos, int k, ACostEstimate costEstimator, CompressionSettings cs) {
        AColumnCoCoder co = CoCoderFactory.createColumnGroupPartitioner(cs.columnPartitioner, est, costEstimator, cs);
        boolean containsEmptyOrConst = CoCoderFactory.containsEmptyOrConst(colInfos);
        if (!containsEmptyOrConst) {
            return co.coCodeColumns(colInfos, k);
        }
        ArrayList<IColIndex> emptyCols = new ArrayList<IColIndex>();
        ArrayList<IColIndex> constCols = new ArrayList<IColIndex>();
        ArrayList<CompressedSizeInfoColGroup> groups = new ArrayList<CompressedSizeInfoColGroup>();
        int nRow = colInfos.compressionInfo.get(0).getNumRows();
        for (int i = 0; i < colInfos.compressionInfo.size(); ++i) {
            CompressedSizeInfoColGroup g = colInfos.compressionInfo.get(i);
            if (g.isEmpty()) {
                emptyCols.add(g.getColumns());
                continue;
            }
            if (g.isConst()) {
                constCols.add(g.getColumns());
                continue;
            }
            groups.add(g);
        }
        colInfos.compressionInfo = groups;
        if (!groups.isEmpty()) {
            colInfos = co.coCodeColumns(colInfos, k);
        }
        if (emptyCols.size() > 0) {
            IColIndex idx = ColIndexFactory.combineIndexes(emptyCols);
            colInfos.compressionInfo.add(new CompressedSizeInfoColGroup(idx, nRow, AColGroup.CompressionType.EMPTY));
        }
        if (constCols.size() > 0) {
            IColIndex idx = ColIndexFactory.combineIndexes(constCols);
            colInfos.compressionInfo.add(new CompressedSizeInfoColGroup(idx, nRow, AColGroup.CompressionType.CONST));
        }
        return colInfos;
    }

    private static boolean containsEmptyOrConst(CompressedSizeInfo colInfos) {
        for (CompressedSizeInfoColGroup g : colInfos.compressionInfo) {
            if (!g.isEmpty() && !g.isConst()) continue;
            return true;
        }
        return false;
    }

    private static AColumnCoCoder createColumnGroupPartitioner(PartitionerType type, AComEst est, ACostEstimate costEstimator, CompressionSettings cs) {
        switch (type) {
            case AUTO: {
                return new CoCodeHybrid(est, costEstimator, cs);
            }
            case GREEDY: {
                return new CoCodeGreedy(est, costEstimator, cs);
            }
            case BIN_PACKING: {
                return new CoCodeBinPacking(est, costEstimator, cs);
            }
            case STATIC: {
                return new CoCodeStatic(est, costEstimator, cs);
            }
            case PRIORITY_QUE: {
                return new CoCodePriorityQue(est, costEstimator, cs);
            }
        }
        throw new RuntimeException("Unsupported column group partitioner: " + type.toString());
    }

    public static enum PartitionerType {
        BIN_PACKING,
        STATIC,
        PRIORITY_QUE,
        GREEDY,
        AUTO;

    }
}

