/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.APreAgg;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.scheme.DDCScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupDDC
extends APreAgg
implements IMapToDataGroup {
    private static final long serialVersionUID = -5769772089913918987L;
    protected final AMapToData _data;

    private ColGroupDDC(IColIndex colIndexes, IDictionary dict, AMapToData data, int[] cachedCounts) {
        super(colIndexes, dict, cachedCounts);
        this._data = data;
        if (CompressedMatrixBlock.debug) {
            if (this.getNumValues() == 0) {
                throw new DMLCompressionException("Invalid construction with empty dictionary");
            }
            if (data.size() == 0) {
                throw new DMLCompressionException("Invalid length of the data. is zero");
            }
            if (data.getUnique() != dict.getNumberOfValues(colIndexes.size())) {
                throw new DMLCompressionException("Invalid map to dict Map has:" + data.getUnique() + " while dict has " + dict.getNumberOfValues(colIndexes.size()));
            }
            int[] c = this.getCounts();
            if (c.length != dict.getNumberOfValues(colIndexes.size())) {
                throw new DMLCompressionException("Invalid DDC Construction");
            }
            data.verify();
        }
    }

    public static AColGroup create(IColIndex colIndexes, IDictionary dict, AMapToData data, int[] cachedCounts) {
        if (data.getUnique() == 1) {
            return ColGroupConst.create(colIndexes, dict);
        }
        if (dict == null) {
            return new ColGroupEmpty(colIndexes);
        }
        return new ColGroupDDC(colIndexes, dict, data, cachedCounts);
    }

    public AColGroup sparsifyFOR() {
        return ColGroupDDCFOR.sparsifyFOR(this);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.DDC;
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb) {
        int r = rl;
        int offT = rl + offR;
        while (r < ru) {
            int vr = this._data.getIndex(r);
            if (!sb.isEmpty(vr)) {
                double[] c = db.values(offT);
                int off = db.pos(offT) + offC;
                int apos = sb.pos(vr);
                int alen = sb.size(vr) + apos;
                int[] aix = sb.indexes(vr);
                double[] aval = sb.values(vr);
                for (int j = apos; j < alen; ++j) {
                    int n = off + this._colIndexes.get(aix[j]);
                    c[n] = c[n] + aval[j];
                }
            }
            ++r;
            ++offT;
        }
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        if (db.isContiguous()) {
            int nCol = db.getDim(1);
            if (this._colIndexes.size() == 1 && nCol == 1) {
                this.decompressToDenseBlockDenseDictSingleColOutContiguous(db, rl, ru, offR, offC, values);
            } else if (this._colIndexes.size() == 1) {
                this.decompressToDenseBlockDenseDictSingleColContiguous(db, rl, ru, offR, offC, values);
            } else if (this._colIndexes.size() == nCol) {
                this.decompressToDenseBlockDenseDictAllColumnsContiguous(db, rl, ru, offR, values);
            } else if (offC == 0 && offR == 0) {
                this.decompressToDenseBlockDenseDictNoOff(db, rl, ru, values);
            } else if (offC == 0) {
                this.decompressToDenseBlockDenseDictNoColOffset(db, rl, ru, offR, values);
            } else {
                this.decompressToDenseBlockDenseDictGeneric(db, rl, ru, offR, offC, values);
            }
        } else {
            this.decompressToDenseBlockDenseDictGeneric(db, rl, ru, offR, offC, values);
        }
    }

    private final void decompressToDenseBlockDenseDictSingleColContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        double[] c = db.values(0);
        int nCols = db.getDim(1);
        int colOff = this._colIndexes.get(0) + offC;
        int i = rl;
        int offT = (rl + offR) * nCols + colOff;
        while (i < ru) {
            int n = offT;
            c[n] = c[n] + values[this._data.getIndex(i)];
            ++i;
            offT += nCols;
        }
    }

    @Override
    public AMapToData getMapToData() {
        return this._data;
    }

    private final void decompressToDenseBlockDenseDictSingleColOutContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        double[] c = db.values(0);
        ColGroupDDC.decompressToDenseBlockDenseDictSingleColOutContiguous(c, rl, ru, offR + this._colIndexes.get(0), values, this._data);
    }

    private static final void decompressToDenseBlockDenseDictSingleColOutContiguous(double[] c, int rl, int ru, int offR, double[] values, AMapToData data) {
        if (data instanceof MapToByte) {
            ColGroupDDC.decompressToDenseBlockDenseDictSingleColOutContiguousByteM(c, rl, ru, offR, values, (MapToByte)data);
        } else if (data instanceof MapToChar) {
            ColGroupDDC.decompressToDenseBlockDenseDictSingleColOutContiguousCharM(c, rl, ru, offR, values, (MapToChar)data);
        } else {
            ColGroupDDC.decompressToDenseBlockDenseDictSingleColOutContiguousGenM(c, rl, ru, offR, values, data);
        }
    }

    private static final void decompressToDenseBlockDenseDictSingleColOutContiguousByteM(double[] c, int rl, int ru, int offR, double[] values, MapToByte data) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[data.getIndex(i)];
        }
    }

    private static final void decompressToDenseBlockDenseDictSingleColOutContiguousCharM(double[] c, int rl, int ru, int offR, double[] values, MapToChar data) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[data.getIndex(i)];
        }
    }

    private static final void decompressToDenseBlockDenseDictSingleColOutContiguousGenM(double[] c, int rl, int ru, int offR, double[] values, AMapToData data) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[data.getIndex(i)];
        }
    }

    private final void decompressToDenseBlockDenseDictAllColumnsContiguous(DenseBlock db, int rl, int ru, int offR, double[] values) {
        double[] c = db.values(0);
        int nCol = this._colIndexes.size();
        for (int r = rl; r < ru; ++r) {
            int start = this._data.getIndex(r) * nCol;
            int end = start + nCol;
            int offStart = (offR + r) * nCol;
            int off = offStart;
            for (int vOff = start; vOff < end; ++vOff) {
                int n = off++;
                c[n] = c[n] + values[vOff];
            }
        }
    }

    private final void decompressToDenseBlockDenseDictNoColOffset(DenseBlock db, int rl, int ru, int offR, double[] values) {
        int nCol = this._colIndexes.size();
        int colOut = db.getDim(1);
        int off = (rl + offR) * colOut;
        int i = rl;
        int offT = rl + offR;
        while (i < ru) {
            double[] c = db.values(offT);
            int rowIndex = this._data.getIndex(i) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes.get(j);
                c[n] = c[n] + values[rowIndex + j];
            }
            ++i;
            off += colOut;
        }
    }

    private final void decompressToDenseBlockDenseDictNoOff(DenseBlock db, int rl, int ru, double[] values) {
        int nCol = this._colIndexes.size();
        int nColU = db.getDim(1);
        double[] c = db.values(0);
        for (int i = rl; i < ru; ++i) {
            int off = i * nColU;
            int rowIndex = this._data.getIndex(i) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes.get(j);
                c[n] = c[n] + values[rowIndex + j];
            }
        }
    }

    private final void decompressToDenseBlockDenseDictGeneric(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        int nCol = this._colIndexes.size();
        int i = rl;
        int offT = rl + offR;
        while (i < ru) {
            double[] c = db.values(offT);
            int off = db.pos(offT) + offC;
            int rowIndex = this._data.getIndex(i) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes.get(j);
                c[n] = c[n] + values[rowIndex + j];
            }
            ++i;
            ++offT;
        }
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        int r = rl;
        int offT = rl + offR;
        while (r < ru) {
            int vr = this._data.getIndex(r);
            if (!sb.isEmpty(vr)) {
                int apos = sb.pos(vr);
                int alen = sb.size(vr) + apos;
                int[] aix = sb.indexes(vr);
                double[] aval = sb.values(vr);
                for (int j = apos; j < alen; ++j) {
                    ret.append(offT, offC + this._colIndexes.get(aix[j]), aval[j]);
                }
            }
            ++r;
            ++offT;
        }
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        int nCol = this._colIndexes.size();
        int i = rl;
        int offT = rl + offR;
        while (i < ru) {
            int rowIndex = this._data.getIndex(i) * nCol;
            for (int j = 0; j < nCol; ++j) {
                ret.append(offT, this._colIndexes.get(j) + offC, values[rowIndex + j]);
            }
            ++i;
            ++offT;
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        return this._dict.getValue(this._data.getIndex(r), colIdx, this._colIndexes.size());
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        for (int rix = rl; rix < ru; ++rix) {
            int n = rix;
            c[n] = c[n] + preAgg[this._data.getIndex(rix)];
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        for (int i = rl; i < ru; ++i) {
            c[i] = builtin.execute(c[i], preAgg[this._data.getIndex(i)]);
        }
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        for (int rix = rl; rix < ru; ++rix) {
            int n = rix;
            c[n] = c[n] * preAgg[this._data.getIndex(rix)];
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this._data.getCounts(counts);
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        if (this._colIndexes.size() == 1) {
            this.leftMultByMatrixNoPreAggSingleCol(matrix, result, rl, ru, cl, cu);
        } else {
            this.lmMatrixNoPreAggMultiCol(matrix, result, rl, ru, cl, cu);
        }
    }

    private void leftMultByMatrixNoPreAggSingleCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        double[] retV = result.getDenseBlockValues();
        int nColM = matrix.getNumColumns();
        int nColRet = result.getNumColumns();
        double[] dictVals = this._dict.getValues();
        if (matrix.isInSparseFormat()) {
            if (cl != 0 || cu != this._data.size()) {
                throw new NotImplementedException();
            }
            this.lmSparseMatrixNoPreAggSingleCol(matrix.getSparseBlock(), nColM, retV, nColRet, dictVals, rl, ru);
        } else {
            this.lmDenseMatrixNoPreAggSingleCol(matrix.getDenseBlockValues(), nColM, retV, nColRet, dictVals, rl, ru, cl, cu);
        }
    }

    private void lmSparseMatrixNoPreAggSingleCol(SparseBlock sb, int nColM, double[] retV, int nColRet, double[] vals, int rl, int ru) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            double[] aval = sb.values(r);
            int offR = r * nColRet;
            for (int i = apos; i < alen; ++i) {
                int n = offR + colOut;
                retV[n] = retV[n] + aval[i] * vals[this._data.getIndex(aix[i])];
            }
        }
    }

    private void lmDenseMatrixNoPreAggSingleCol(double[] mV, int nColM, double[] retV, int nColRet, double[] vals, int rl, int ru, int cl, int cu) {
        int colOut = this._colIndexes.get(0);
        for (int r = rl; r < ru; ++r) {
            int offL = r * nColM;
            int offR = r * nColRet;
            for (int c = cl; c < cu; ++c) {
                int n = offR + colOut;
                retV[n] = retV[n] + mV[offL + c] * vals[this._data.getIndex(c)];
            }
        }
    }

    private void lmMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        if (matrix.isInSparseFormat()) {
            if (cl != 0 || cu != this._data.size()) {
                throw new NotImplementedException("Not implemented left multiplication on sparse without it being entire input");
            }
            this.lmSparseMatrixNoPreAggMultiCol(matrix, result, rl, ru);
        } else {
            this.lmDenseMatrixNoPreAggMultiCol(matrix, result, rl, ru, cl, cu);
        }
    }

    private void lmSparseMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru) {
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        SparseBlock sb = matrix.getSparseBlock();
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            double[] aval = sb.values(r);
            int offR = r * nColRet;
            for (int i = apos; i < alen; ++i) {
                this._dict.multiplyScalar(aval[i], retV, offR, this._data.getIndex(aix[i]), this._colIndexes);
            }
        }
    }

    private void lmDenseMatrixNoPreAggMultiCol(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        double[] retV = result.getDenseBlockValues();
        int nColM = matrix.getNumColumns();
        int nColRet = result.getNumColumns();
        double[] mV = matrix.getDenseBlockValues();
        for (int r = rl; r < ru; ++r) {
            int offL = r * nColM;
            int offR = r * nColRet;
            for (int c = cl; c < cu; ++c) {
                this._dict.multiplyScalar(mV[offL + c], retV, offR, this._data.getIndex(c), this._colIndexes);
            }
        }
    }

    @Override
    public void preAggregateDense(MatrixBlock m, double[] preAgg, int rl, int ru, int cl, int cu) {
        this._data.preAggregateDense(m, preAgg, rl, ru, cl, cu);
    }

    @Override
    public void preAggregateSparse(SparseBlock sb, double[] preAgg, int rl, int ru) {
        this._data.preAggregateSparse(sb, preAgg, rl, ru);
    }

    @Override
    public void preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        this._data.preAggregateDDC_DDC(that._data, that._dict, ret, that._colIndexes.size());
    }

    @Override
    public void preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        this._data.preAggregateDDC_SDCZ(that._data, that._dict, that._indexes, ret, that._colIndexes.size());
    }

    @Override
    public void preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        AOffsetIterator itThat = that._indexes.getOffsetIterator();
        int nCol = that._colIndexes.size();
        int finalOff = that._indexes.getOffsetToLast();
        double[] v = ret.getValues();
        while (true) {
            int to = this._data.getIndex(itThat.value());
            that._dict.addToEntry(v, 0, to, nCol);
            if (itThat.value() == finalOff) break;
            itThat.next();
        }
    }

    @Override
    protected void preAggregateThatRLEStructure(ColGroupRLE that, Dictionary ret) {
        this._data.preAggregateDDC_RLE(that._ptr, that._data, that._dict, ret, that._colIndexes.size());
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        return that instanceof ColGroupDDC && ((ColGroupDDC)that)._data == this._data;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.DDC;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += this._data.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        if (op.fn instanceof Plus || op.fn instanceof Minus) {
            double v0 = op.executeScalar(0.0);
            if (v0 == 0.0) {
                return this;
            }
            double[] reference = ColGroupUtils.createReference(this._colIndexes.size(), v0);
            return ColGroupDDCFOR.create(this._colIndexes, this._dict, this._data, this.getCachedCounts(), reference);
        }
        return ColGroupDDC.create(this._colIndexes, this._dict.applyScalarOp(op), this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        return ColGroupDDC.create(this._colIndexes, this._dict.applyUnaryOp(op), this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        IDictionary ret = this._dict.binOpLeft(op, v, this._colIndexes);
        return ColGroupDDC.create(this._colIndexes, ret, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        if ((op.fn instanceof Plus || op.fn instanceof Minus) && this._dict instanceof MatrixBlockDictionary && ((MatrixBlockDictionary)this._dict).getMatrixBlock().isInSparseFormat()) {
            double[] reference = ColGroupUtils.binaryDefRowRight(op, v, this._colIndexes);
            return ColGroupDDCFOR.create(this._colIndexes, this._dict, this._data, this.getCachedCounts(), reference);
        }
        IDictionary ret = this._dict.binOpRight(op, v, this._colIndexes);
        return ColGroupDDC.create(this._colIndexes, ret, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._data.write(out);
    }

    public static ColGroupDDC read(DataInput in) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        IDictionary dict = DictionaryFactory.read(in);
        AMapToData data = MapToFactory.readIn(in);
        return new ColGroupDDC(cols, dict, data, null);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += this._data.getExactSizeOnDisk();
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        return e.getCost(nRows, nRows, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected int numRowsToMultiply() {
        return this._data.size();
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        return this._dict.aggregate(c, builtin);
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        this._dict.aggregateCols(c, builtin, this._colIndexes);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._dict.containsValue(pattern);
    }

    @Override
    protected AColGroup allocateRightMultiplication(MatrixBlock right, IColIndex colIndexes, IDictionary preAgg) {
        if (preAgg != null) {
            return ColGroupDDC.create(colIndexes, preAgg, this._data, this.getCachedCounts());
        }
        return null;
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        try {
            return ColGroupDDC.create(this._colIndexes, this._dict, this._data.slice(rl, ru), null);
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed to slice out sub part DDC: " + rl + " " + ru, e);
        }
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, IDictionary newDictionary) {
        return ColGroupDDC.create(colIndexes, newDictionary, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup append(AColGroup g) {
        if (g instanceof ColGroupDDC) {
            if (g.getColIndices().equals(this._colIndexes)) {
                ColGroupDDC gDDC = (ColGroupDDC)g;
                if (gDDC._dict.equals(this._dict)) {
                    AMapToData nd = this._data.append(gDDC._data);
                    return ColGroupDDC.create(this._colIndexes, this._dict, nd, null);
                }
                LOG.warn((Object)("Not same Dictionaries therefore not appending DDC\n" + this._dict + "\n\n" + gDDC._dict));
            } else {
                LOG.warn((Object)("Not same columns therefore not appending DDC\n" + this._colIndexes + "\n\n" + g.getColIndices()));
            }
        } else {
            LOG.warn((Object)("Not DDC but " + g.getClass().getSimpleName() + ", therefore not appending DDC"));
        }
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        for (int i = 1; i < g.length; ++i) {
            if (!this._colIndexes.equals(g[i]._colIndexes)) {
                LOG.warn((Object)("Not same columns therefore not appending DDC\n" + this._colIndexes + "\n\n" + g[i]._colIndexes));
                return null;
            }
            if (!(g[i] instanceof ColGroupDDC)) {
                LOG.warn((Object)("Not DDC but " + g[i].getClass().getSimpleName() + ", therefore not appending DDC"));
                return null;
            }
            ColGroupDDC gDDC = (ColGroupDDC)g[i];
            if (gDDC._dict.equals(this._dict)) continue;
            LOG.warn((Object)("Not same Dictionaries therefore not appending DDC\n" + this._dict + "\n\n" + gDDC._dict));
            return null;
        }
        AMapToData nd = this._data.appendN((IMapToDataGroup[])Arrays.copyOf(g, g.length, IMapToDataGroup[].class));
        return ColGroupDDC.create(this._colIndexes, this._dict, nd, null);
    }

    @Override
    public ICLAScheme getCompressionScheme() {
        return DDCScheme.create(this);
    }

    @Override
    public AColGroup recompress() {
        return this;
    }

    @Override
    public CompressedSizeInfoColGroup getCompressionInfo(int nRow) {
        IEncode enc = this.getEncoding();
        EstimationFactors ef = new EstimationFactors(this.getNumValues(), this._data.size(), this._data.size(), this._dict.getSparsity());
        return new CompressedSizeInfoColGroup(this._colIndexes, ef, this.estimateInMemorySize(), this.getCompType(), enc);
    }

    @Override
    public IEncode getEncoding() {
        return EncodingFactory.create(this._data);
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        return ColGroupDDC.create(newColIndex, this._dict.reorder(reordering), this._data, this.getCachedCounts());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this._data);
        return sb.toString();
    }
}

