/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5.message;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5Message;

public class H5DataSpaceMessage
extends H5Message {
    private boolean maxSizesPresent;
    private long totalLength;

    public H5DataSpaceMessage(H5RootObject rootObject, BitSet flags) {
        super(rootObject, flags);
    }

    public H5DataSpaceMessage(H5RootObject rootObject, BitSet flags, ByteBuffer bb) {
        super(rootObject, flags);
        int i;
        rootObject.setDataSpaceVersion(bb.get());
        rootObject.setRank(bb.get());
        byte[] flagBits = new byte[1];
        bb.get(flagBits);
        BitSet maxFlags = BitSet.valueOf(flagBits);
        this.maxSizesPresent = maxFlags.get(0);
        bb.position(bb.position() + 5);
        if (rootObject.getRank() != 0) {
            int[] dimensions = new int[rootObject.getRank()];
            for (i = 0; i < rootObject.getRank(); ++i) {
                dimensions[i] = Utils.readBytesAsUnsignedInt(bb, rootObject.getSuperblock().sizeOfLengths);
            }
            rootObject.setDimensions(dimensions);
        } else {
            rootObject.setDimensions(new int[0]);
        }
        if (this.maxSizesPresent) {
            int[] maxSizes = new int[rootObject.getRank()];
            for (i = 0; i < rootObject.getRank(); ++i) {
                maxSizes[i] = Utils.readBytesAsUnsignedInt(bb, rootObject.getSuperblock().sizeOfLengths);
            }
            rootObject.setMaxSizes(maxSizes);
        } else {
            rootObject.setMaxSizes(new int[0]);
        }
        this.totalLength = IntStream.of(rootObject.getDimensions()).mapToLong(Long::valueOf).reduce(1L, Math::multiplyExact);
    }

    @Override
    public void toBuffer(H5BufferBuilder bb) {
        int i;
        super.toBuffer(bb, 1);
        bb.writeByte(this.rootObject.getDataSpaceVersion());
        bb.writeByte(this.rootObject.getRank());
        int flag = 0;
        if (this.rootObject.getMaxSizes() != null && this.rootObject.getMaxSizes().length > 0) {
            flag = 1;
        }
        bb.writeByte(flag);
        byte[] reserved = new byte[5];
        bb.writeBytes(reserved);
        if (this.rootObject.getRank() != 0) {
            for (i = 0; i < this.rootObject.getRank(); ++i) {
                bb.write(this.rootObject.getDimensions()[i], this.rootObject.getSuperblock().sizeOfLengths);
            }
        }
        if (flag == 1) {
            for (i = 0; i < this.rootObject.getRank(); ++i) {
                bb.write(this.rootObject.getMaxSizes()[i], this.rootObject.getSuperblock().sizeOfLengths);
            }
        }
    }

    public boolean isMaxSizesPresent() {
        return this.maxSizesPresent;
    }

    public long getTotalLength() {
        return this.totalLength;
    }
}

