/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public interface IColIndex {
    public int size();

    public int get(int var1);

    public IColIndex shift(int var1);

    public void write(DataOutput var1) throws IOException;

    public long getExactSizeOnDisk();

    public long estimateInMemorySize();

    public IIterate iterator();

    public int findIndex(int var1);

    public SliceResult slice(int var1, int var2);

    public boolean equals(Object var1);

    public boolean equals(IColIndex var1);

    public int hashCode();

    public boolean contains(IColIndex var1, IColIndex var2);

    public boolean containsStrict(IColIndex var1, IColIndex var2);

    public IColIndex combine(IColIndex var1);

    public boolean isContiguous();

    public int[] getReorderingIndex();

    public boolean isSorted();

    public IColIndex sort();

    public boolean contains(int var1);

    public boolean containsAny(IColIndex var1);

    public double avgOfIndex();

    public void decompressToDenseFromSparse(SparseBlock var1, int var2, int var3, double[] var4);

    public void decompressVec(int var1, double[] var2, int var3, double[] var4, int var5);

    public static boolean inOrder(IColIndex a, IColIndex b) {
        return a.get(a.size() - 1) < b.get(0);
    }

    public static Pair<int[], int[]> reorderingIndexes(IColIndex a, IColIndex b) {
        int[] ar = new int[a.size()];
        int[] br = new int[b.size()];
        IIterate ai = a.iterator();
        IIterate bi = b.iterator();
        int ia = 0;
        int ib = 0;
        int i = 0;
        while (ai.hasNext() && bi.hasNext()) {
            if (ai.v() < bi.v()) {
                ar[ia++] = i++;
                ai.next();
                continue;
            }
            br[ib++] = i++;
            bi.next();
        }
        while (ai.hasNext()) {
            ar[ia++] = i++;
            ai.next();
        }
        while (bi.hasNext()) {
            br[ib++] = i++;
            bi.next();
        }
        return new Pair<int[], int[]>(ar, br);
    }

    public static class SliceResult {
        public final int idStart;
        public final int idEnd;
        public final IColIndex ret;

        protected SliceResult(int idStart, int idEnd, IColIndex ret) {
            this.idStart = idStart;
            this.idEnd = idEnd;
            this.ret = ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("SliceResult:[");
            sb.append(this.idStart);
            sb.append("-");
            sb.append(this.idEnd);
            sb.append(" ");
            sb.append(this.ret);
            sb.append("]");
            return sb.toString();
        }
    }

    public static enum ColIndexType {
        SINGLE,
        TWO,
        ARRAY,
        RANGE,
        TWORANGE,
        COMBINED,
        UNKNOWN;

    }
}

