/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToByte
extends AMapToData {
    private static final long serialVersionUID = -2498505439667351828L;
    protected final byte[] _data;

    protected MapToByte(int size) {
        this(256, size);
    }

    public MapToByte(int unique, int size) {
        super(Math.min(unique, 256));
        this._data = new byte[size];
    }

    protected MapToByte(int unique, byte[] data) {
        super(unique);
        this._data = data;
        this.verify();
    }

    protected MapToUByte toUByte() {
        return new MapToUByte(this.getUnique(), this._data);
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.BYTE;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n] & 0xFF;
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (byte)v);
    }

    @Override
    public long getInMemorySize() {
        return MapToByte.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        size = (long)((double)size + MemoryEstimates.byteArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = (byte)v;
    }

    @Override
    public void set(int l, int u, int off, AMapToData tm) {
        if (tm instanceof MapToByte) {
            MapToByte tbm = (MapToByte)tm;
            byte[] tbv = tbm._data;
            int i = l;
            while (i < u) {
                this._data[i] = tbv[off];
                ++i;
                ++off;
            }
        } else {
            int i = l;
            while (i < u) {
                this._data[i] = (byte)tm.getIndex(off);
                ++i;
                ++off;
            }
        }
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = (byte)v;
        return this._data[n] & 0xFF;
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.BYTE.ordinal());
        this.writeBytes(out);
    }

    protected void writeBytes(DataOutput out) throws IOException {
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        out.write(this._data);
    }

    protected static MapToByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        byte[] data = new byte[length];
        in.readFully(data);
        return new MapToByte(unique, data);
    }

    @Override
    public void replace(int v, int r) {
        byte cv = (byte)v;
        byte rv = (byte)r;
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    public void copyInt(int[] d, int start, int end) {
        for (int i = start; i < end; ++i) {
            this._data[i] = (byte)d[i];
        }
    }

    @Override
    public void copyBit(MapToBit d) {
        this.fill(0);
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this._data[i] = 1;
            i = d.nextSetBit(i + 1);
        }
    }

    @Override
    public int[] getCounts(int[] ret) {
        int h = this._data.length % 8;
        for (int i = 0; i < h; ++i) {
            int n = this._data[i] & 0xFF;
            ret[n] = ret[n] + 1;
        }
        this.getCountsBy8P(ret, h, this._data.length);
        return ret;
    }

    private void getCountsBy8P(int[] ret, int s, int e) {
        for (int i = s; i < e; i += 8) {
            int n = this._data[i] & 0xFF;
            ret[n] = ret[n] + 1;
            int n2 = this._data[i + 1] & 0xFF;
            ret[n2] = ret[n2] + 1;
            int n3 = this._data[i + 2] & 0xFF;
            ret[n3] = ret[n3] + 1;
            int n4 = this._data[i + 3] & 0xFF;
            ret[n4] = ret[n4] + 1;
            int n5 = this._data[i + 4] & 0xFF;
            ret[n5] = ret[n5] + 1;
            int n6 = this._data[i + 5] & 0xFF;
            ret[n6] = ret[n6] + 1;
            int n7 = this._data[i + 6] & 0xFF;
            ret[n7] = ret[n7] + 1;
            int n8 = this._data[i + 7] & 0xFF;
            ret[n8] = ret[n8] + 1;
        }
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }

    @Override
    public int getUpperBoundValue() {
        return 255;
    }

    @Override
    public int countRuns() {
        int c = 1;
        byte prev = this._data[0];
        for (int i = 1; i < this._data.length; ++i) {
            c += prev == this._data[i] ? 0 : 1;
            prev = this._data[i];
        }
        return c;
    }

    @Override
    public AMapToData resize(int unique) {
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique != 2 || size <= 32) {
            if (unique <= 128) {
                MapToUByte ret = this.toUByte();
                ret.setUnique(unique);
                return ret;
            }
            this.setUnique(unique);
            return this;
        }
        MapToBit ret = new MapToBit(unique, size);
        ret.copy(this);
        return ret;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToByte(this.getUnique(), Arrays.copyOfRange(this._data, l, u));
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToByte) {
            MapToByte tb = (MapToByte)t;
            byte[] tbb = tb._data;
            int newSize = this._data.length + t.size();
            int newDistinct = Math.max(this.getUnique(), t.getUnique());
            byte[] ret = Arrays.copyOf(this._data, newSize);
            System.arraycopy(tbb, 0, ret, this._data.length, t.size());
            if (newDistinct < 128) {
                return new MapToUByte(newDistinct, ret);
            }
            return new MapToByte(newDistinct, ret);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(IMapToDataGroup[] d) {
        int p = 0;
        for (IMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        byte[] ret = new byte[p];
        p = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getMapToData().size() <= 0) continue;
            MapToByte mm = (MapToByte)d[i].getMapToData();
            int ms = mm.size();
            System.arraycopy(mm._data, 0, ret, p, ms);
            p += ms;
        }
        if (this.getUnique() < 128) {
            return new MapToUByte(this.getUnique(), ret);
        }
        return new MapToByte(this.getUnique(), ret);
    }

    @Override
    public void lmSparseMatrixRow(SparseBlock sb, int r, DenseBlock db, IColIndex colIndexes, IDictionary dict) {
        if (sb.isEmpty(r)) {
            return;
        }
        int pos = db.pos(r);
        double[] retV = db.values(r);
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] aval = sb.values(r);
        for (int i = apos; i < alen; ++i) {
            dict.multiplyScalar(aval[i], retV, pos, this.getIndex(aix[i]), colIndexes);
        }
    }

    @Override
    public boolean equals(AMapToData e) {
        return e instanceof MapToByte && e.getUnique() == this.getUnique() && Arrays.equals(((MapToByte)e)._data, this._data);
    }

    @Override
    protected void decompressToRangeNoOffBy8(double[] c, int r, double[] values) {
        int n = r;
        c[n] = c[n] + values[this.getIndex(r)];
        int n2 = r + 1;
        c[n2] = c[n2] + values[this.getIndex(r + 1)];
        int n3 = r + 2;
        c[n3] = c[n3] + values[this.getIndex(r + 2)];
        int n4 = r + 3;
        c[n4] = c[n4] + values[this.getIndex(r + 3)];
        int n5 = r + 4;
        c[n5] = c[n5] + values[this.getIndex(r + 4)];
        int n6 = r + 5;
        c[n6] = c[n6] + values[this.getIndex(r + 5)];
        int n7 = r + 6;
        c[n7] = c[n7] + values[this.getIndex(r + 6)];
        int n8 = r + 7;
        c[n8] = c[n8] + values[this.getIndex(r + 7)];
    }

    @Override
    public void decompressToRange(double[] c, int rl, int ru, int offR, double[] values) {
        if (offR == 0) {
            this.decompressToRangeNoOff(c, rl, ru, values);
        } else {
            this.decompressToRangeOff(c, rl, ru, offR, values);
        }
    }

    @Override
    protected void decompressToRangeOff(double[] c, int rl, int ru, int offR, double[] values) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[this.getIndex(i)];
        }
    }

    @Override
    protected void decompressToRangeNoOff(double[] c, int rl, int ru, double[] values) {
        int rc;
        int h = (ru - rl) % 8;
        for (rc = rl; rc < rl + h; ++rc) {
            int n = rc;
            c[n] = c[n] + values[this.getIndex(rc)];
        }
        for (rc = rl + h; rc < ru; rc += 8) {
            this.decompressToRangeNoOffBy8(c, rc, values);
        }
    }
}

