/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerDecommissioner$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.FallbackStorage;
import org.apache.spark.storage.FallbackStorage$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEd!B A\u0001\u0001C\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011m\u0003!\u0011!Q\u0001\nqCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004n\u0001\u0001\u0006Ia\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019\u0019\b\u0001)A\u0005a\"AA\u000f\u0001a\u0001\n\u0003\u0001U\u000f\u0003\u0005z\u0001\u0001\u0007I\u0011\u0001!{\u0011\u001d\t\t\u0001\u0001Q!\nYD\u0011\"a\u0003\u0001\u0001\u0004%\t\u0001Q;\t\u0015\u00055\u0001\u00011A\u0005\u0002\u0001\u000by\u0001C\u0004\u0002\u0014\u0001\u0001\u000b\u0015\u0002<\t\u0015\u0005]\u0001\u00011A\u0005\u0002\u0001\u000bI\u0002\u0003\u0006\u0002\"\u0001\u0001\r\u0011\"\u0001A\u0003GA\u0001\"a\n\u0001A\u0003&\u00111\u0004\u0005\u000b\u0003W\u0001\u0001\u0019!C\u0001\u0001\u0006e\u0001BCA\u0017\u0001\u0001\u0007I\u0011\u0001!\u00020!A\u00111\u0007\u0001!B\u0013\tYB\u0002\u0004\u00028\u0001!\u0011\u0011\b\u0005\u000b\u0003#\"\"\u0011!Q\u0001\n\u0005M\u0003B\u00021\u0015\t\u0003\tI\u0006C\u0005\u0002bQ\u0001\r\u0011\"\u0001\u0002\u001a!I\u00111\r\u000bA\u0002\u0013\u0005\u0011Q\r\u0005\t\u0003S\"\u0002\u0015)\u0003\u0002\u001c!9\u0011Q\u000e\u000b\u0005\n\u0005=\u0004bBAC)\u0011%\u0011q\u0011\u0005\b\u0003\u001f#B\u0011IAI\u0011)\t\u0019\n\u0001b\u0001\n\u0003\u0001\u0015Q\u0013\u0005\t\u0003O\u0003\u0001\u0015!\u0003\u0002\u0018\"Q\u0011\u0011\u0016\u0001C\u0002\u0013\u0005\u0001)a+\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003[C!\"a1\u0001\u0005\u0004%\t\u0001QAc\u0011!\ty\r\u0001Q\u0001\n\u0005\u001d\u0007\"CAi\u0001\u0001\u0007I\u0011BA\r\u0011%\t\u0019\u000e\u0001a\u0001\n\u0013\t)\u000e\u0003\u0005\u0002Z\u0002\u0001\u000b\u0015BA\u000e\u0011)\ti\u000e\u0001a\u0001\n\u0003\u0001\u0015\u0011\u0004\u0005\u000b\u0003?\u0004\u0001\u0019!C\u0001\u0001\u0006\u0005\b\u0002CAs\u0001\u0001\u0006K!a\u0007\t\u0013\u0005%\b\u00011A\u0005\n\u0005e\u0001\"CAv\u0001\u0001\u0007I\u0011BAw\u0011!\t\t\u0010\u0001Q!\n\u0005m\u0001\"CA{\u0001\t\u0007I\u0011BA|\u0011!\ty\u0010\u0001Q\u0001\n\u0005e\b\"\u0003B\u0001\u0001\t\u0007I\u0011\u0002B\u0002\u0011!\u0011i\u0001\u0001Q\u0001\n\t\u0015\u0001\"\u0003B\b\u0001\t\u0007I\u0011\u0002B\t\u0011!\u0011I\u0002\u0001Q\u0001\n\tM\u0001\"\u0003B\u0010\u0001\t\u0007I\u0011\u0002B\u0002\u0011!\u0011\t\u0003\u0001Q\u0001\n\t\u0015\u0001\"\u0003B\u0012\u0001\t\u0007I\u0011\u0002B\u0013\u0011!\u0011Y\u0003\u0001Q\u0001\n\t\u001d\u0002\"\u0003B\u0018\u0001\t\u0007I\u0011\u0002B\u0002\u0011!\u0011\t\u0004\u0001Q\u0001\n\t\u0015\u0001\u0002\u0003B\u001a\u0001\u0011\u0005\u0001I!\u000e\t\u0011\t]\u0002\u0001\"\u0001A\u0003#C\u0001B!\u000f\u0001\t\u0003\u0001%Q\u0007\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u00119\u0007\u0001C\u0001\u0003#CqA!\u001b\u0001\t\u0003\t\t\n\u0003\u0005\u0003l\u0001!\t\u0001\u0011B7\u0005i\u0011En\\2l\u001b\u0006t\u0017mZ3s\t\u0016\u001cw.\\7jgNLwN\\3s\u0015\t\t%)A\u0004ti>\u0014\u0018mZ3\u000b\u0005\r#\u0015!B:qCJ\\'BA#G\u0003\u0019\t\u0007/Y2iK*\tq)A\u0002pe\u001e\u001c2\u0001A%P!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0019\te.\u001f*fMB\u0011\u0001kU\u0007\u0002#*\u0011!KQ\u0001\tS:$XM\u001d8bY&\u0011A+\u0015\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0004\u0001A\u0011\u0001,W\u0007\u0002\u0005&\u0011!L\u0011\u0002\n'B\f'o[\"p]\u001a\f!AY7\u0011\u0005usV\"\u0001!\n\u0005}\u0003%\u0001\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002cG\u0012\u0004\"!\u0018\u0001\t\u000bU\u001b\u0001\u0019A,\t\u000bm\u001b\u0001\u0019\u0001/\u0002\u001f\u0019\fG\u000e\u001c2bG.\u001cFo\u001c:bO\u0016,\u0012a\u001a\t\u0004\u0015\"T\u0017BA5L\u0005\u0019y\u0005\u000f^5p]B\u0011Ql[\u0005\u0003Y\u0002\u0013qBR1mY\n\f7m[*u_J\fw-Z\u0001\u0011M\u0006dGNY1dWN#xN]1hK\u0002\nQ%\\1y%\u0016\u0004H.[2bi&|gNR1jYV\u0014Xm\u001d$pe\u0012+7m\\7nSN\u001c\u0018n\u001c8\u0016\u0003A\u0004\"AS9\n\u0005I\\%aA%oi\u00061S.\u0019=SKBd\u0017nY1uS>tg)Y5mkJ,7OR8s\t\u0016\u001cw.\\7jgNLwN\u001c\u0011\u0002)1\f7\u000f\u001e*E\t6KwM]1uS>tG+[7f+\u00051\bC\u0001&x\u0013\tA8J\u0001\u0003M_:<\u0017\u0001\u00077bgR\u0014F\tR'jOJ\fG/[8o)&lWm\u0018\u0013fcR\u00111P \t\u0003\u0015rL!!`&\u0003\tUs\u0017\u000e\u001e\u0005\b\u007f&\t\t\u00111\u0001w\u0003\rAH%M\u0001\u0016Y\u0006\u001cHO\u0015#E\u001b&<'/\u0019;j_:$\u0016.\\3!Q\rQ\u0011Q\u0001\t\u0004\u0015\u0006\u001d\u0011bAA\u0005\u0017\nAao\u001c7bi&dW-\u0001\rmCN$8\u000b[;gM2,W*[4sCRLwN\u001c+j[\u0016\fA\u0004\\1tiNCWO\u001a4mK6KwM]1uS>tG+[7f?\u0012*\u0017\u000fF\u0002|\u0003#Aqa \u0007\u0002\u0002\u0003\u0007a/A\rmCN$8\u000b[;gM2,W*[4sCRLwN\u001c+j[\u0016\u0004\u0003fA\u0007\u0002\u0006\u0005i!\u000f\u001a3CY>\u001c7n\u001d'fMR,\"!a\u0007\u0011\u0007)\u000bi\"C\u0002\u0002 -\u0013qAQ8pY\u0016\fg.A\tsI\u0012\u0014En\\2lg2+g\r^0%KF$2a_A\u0013\u0011!yx\"!AA\u0002\u0005m\u0011A\u0004:eI\ncwnY6t\u0019\u00164G\u000f\t\u0015\u0004!\u0005\u0015\u0011!E:ik\u001a4G.\u001a\"m_\u000e\\7\u000fT3gi\u0006)2\u000f[;gM2,'\t\\8dWNdUM\u001a;`I\u0015\fHcA>\u00022!AqPEA\u0001\u0002\u0004\tY\"\u0001\ntQV4g\r\\3CY>\u001c7n\u001d'fMR\u0004\u0003fA\n\u0002\u0006\tA2\u000b[;gM2,W*[4sCRLwN\u001c*v]:\f'\r\\3\u0014\u000bQ\tY$a\u0013\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!A.\u00198h\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA%\u0003\u007f\u0011aa\u00142kK\u000e$\b\u0003BA\u001f\u0003\u001bJA!a\u0014\u0002@\tA!+\u001e8oC\ndW-\u0001\u0003qK\u0016\u0014\bcA/\u0002V%\u0019\u0011q\u000b!\u0003\u001d\tcwnY6NC:\fw-\u001a:JIR!\u00111LA0!\r\ti\u0006F\u0007\u0002\u0001!9\u0011\u0011\u000b\fA\u0002\u0005M\u0013aC6fKB\u0014VO\u001c8j]\u001e\fqb[3faJ+hN\\5oO~#S-\u001d\u000b\u0004w\u0006\u001d\u0004\u0002C@\u0019\u0003\u0003\u0005\r!a\u0007\u0002\u0019-,W\r\u001d*v]:Lgn\u001a\u0011)\u0007e\t)!\u0001\u0006bY2|wOU3uef$b!a\u0007\u0002r\u0005\u0005\u0005bBA:5\u0001\u0007\u0011QO\u0001\rg\",hM\u001a7f\u00052|7m\u001b\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111\u0010\"\u0002\u000fMDWO\u001a4mK&!\u0011qPA=\u0005A\u0019\u0006.\u001e4gY\u0016\u0014En\\2l\u0013:4w\u000e\u0003\u0004\u0002\u0004j\u0001\r\u0001]\u0001\u000bM\u0006LG.\u001e:f\u001dVl\u0017!\u00078fqR\u001c\u0006.\u001e4gY\u0016\u0014En\\2l)>l\u0015n\u001a:bi\u0016$\"!!#\u0011\r)\u000bY)!\u001eq\u0013\r\tii\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0007I,h\u000eF\u0001|\u0003Ei\u0017n\u001a:bi&twm\u00155vM\u001adWm]\u000b\u0003\u0003/\u0003b!!'\u0002$\u0006UTBAAN\u0015\u0011\ti*a(\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011U&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002&\u0006m%a\u0002%bg\"\u001cV\r^\u0001\u0013[&<'/\u0019;j]\u001e\u001c\u0006.\u001e4gY\u0016\u001c\b%A\nok6l\u0015n\u001a:bi\u0016$7\u000b[;gM2,7/\u0006\u0002\u0002.B!\u0011qVA_\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016AB1u_6L7M\u0003\u0003\u00028\u0006e\u0016AC2p]\u000e,(O]3oi*!\u00111XA\"\u0003\u0011)H/\u001b7\n\t\u0005}\u0016\u0011\u0017\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002)9,X.T5he\u0006$X\rZ*ik\u001a4G.Z:!\u0003E\u0019\b.\u001e4gY\u0016\u001cHk\\'jOJ\fG/Z\u000b\u0003\u0003\u000f\u0004b!!3\u0002L\u0006%UBAA[\u0013\u0011\ti-!.\u0003+\r{gnY;se\u0016tG\u000fT5oW\u0016$\u0017+^3vK\u0006\u00112\u000f[;gM2,7\u000fV8NS\u001e\u0014\u0018\r^3!\u0003\u001d\u0019Ho\u001c9qK\u0012\f1b\u001d;paB,Gm\u0018\u0013fcR\u001910a6\t\u0011}$\u0013\u0011!a\u0001\u00037\t\u0001b\u001d;paB,G\r\t\u0015\u0004K\u0005\u0015\u0011AC:u_B\u0004X\r\u001a*E\t\u0006q1\u000f^8qa\u0016$'\u000b\u0012#`I\u0015\fHcA>\u0002d\"AqpJA\u0001\u0002\u0004\tY\"A\u0006ti>\u0004\b/\u001a3S\t\u0012\u0003\u0003f\u0001\u0015\u0002\u0006\u0005q1\u000f^8qa\u0016$7\u000b[;gM2,\u0017AE:u_B\u0004X\rZ*ik\u001a4G.Z0%KF$2a_Ax\u0011!y(&!AA\u0002\u0005m\u0011aD:u_B\u0004X\rZ*ik\u001a4G.\u001a\u0011)\u0007-\n)!\u0001\bnS\u001e\u0014\u0018\r^5p]B+WM]:\u0016\u0005\u0005e\b\u0003CAM\u0003w\f\u0019&a\u0017\n\t\u0005u\u00181\u0014\u0002\b\u0011\u0006\u001c\b.T1q\u0003=i\u0017n\u001a:bi&|g\u000eU3feN\u0004\u0013!\u0007:eI\ncwnY6NS\u001e\u0014\u0018\r^5p]\u0016CXmY;u_J,\"A!\u0002\u0011\t)C'q\u0001\t\u0005\u0003\u0013\u0014I!\u0003\u0003\u0003\f\u0005U&A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\f!D\u001d3e\u00052|7m['jOJ\fG/[8o\u000bb,7-\u001e;pe\u0002\n\u0011D\u001d3e\u00052|7m['jOJ\fG/[8o%Vtg.\u00192mKV\u0011!1\u0003\n\u0007\u0005+\tY$a\u0013\u0007\r\t]\u0011\u0007\u0001B\n\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003i\u0011H\r\u001a\"m_\u000e\\W*[4sCRLwN\u001c*v]:\f'\r\\3!\u0011%\u0011iB!\u0006C\u0002\u0013\u0005Q/A\u0007tY\u0016,\u0007/\u00138uKJ4\u0018\r\\\u0001%g\",hM\u001a7f\u00052|7m['jOJ\fG/[8o%\u00164'/Z:i\u000bb,7-\u001e;pe\u0006)3\u000f[;gM2,'\t\\8dW6KwM]1uS>t'+\u001a4sKNDW\t_3dkR|'\u000fI\u0001%g\",hM\u001a7f\u00052|7m['jOJ\fG/[8o%\u00164'/Z:i%Vtg.\u00192mKV\u0011!q\u0005\n\u0007\u0005S\tY$a\u0013\u0007\r\t]Q\u0007\u0001B\u0014\u0003\u0015\u001a\b.\u001e4gY\u0016\u0014En\\2l\u001b&<'/\u0019;j_:\u0014VM\u001a:fg\"\u0014VO\u001c8bE2,\u0007\u0005C\u0005\u0003\u001e\t%\"\u0019!C\u0001k\u0006!2\u000f[;gM2,W*[4sCRLwN\u001c)p_2\fQc\u001d5vM\u001adW-T5he\u0006$\u0018n\u001c8Q_>d\u0007%\u0001\u0010sK\u001a\u0014Xm\u001d5NS\u001e\u0014\u0018\r^1cY\u0016\u001c\u0006.\u001e4gY\u0016\u0014En\\2lgR\u0011\u00111D\u0001\u001bgR|\u0007/T5he\u0006$\u0018N\\4TQV4g\r\\3CY>\u001c7n]\u0001\u001bI\u0016\u001cw.\\7jgNLwN\u001c*eI\u000e\u000b7\r[3CY>\u001c7n]\u0001\r[&<'/\u0019;f\u00052|7m\u001b\u000b\u0005\u00037\u0011y\u0004C\u0004\u0003Bm\u0002\rAa\u0011\u0002!\tdwnY6U_J+\u0007\u000f\\5dCR,\u0007\u0003\u0002B#\u0005CrAAa\u0012\u0003^9!!\u0011\nB.\u001d\u0011\u0011YE!\u0017\u000f\t\t5#q\u000b\b\u0005\u0005\u001f\u0012)&\u0004\u0002\u0003R)\u0019!1\u000b,\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0015BA#G\u0013\t\u0019E)\u0003\u0002B\u0005&\u0019!q\f!\u0002)\tcwnY6NC:\fw-\u001a:NKN\u001c\u0018mZ3t\u0013\u0011\u0011\u0019G!\u001a\u0003\u001dI+\u0007\u000f\\5dCR,'\t\\8dW*\u0019!q\f!\u0002\u000bM$\u0018M\u001d;\u0002\tM$x\u000e]\u0001\u0012Y\u0006\u001cH/T5he\u0006$\u0018n\u001c8J]\u001a|GC\u0001B8!\u0019Q\u00151\u0012<\u0002\u001c\u0001")
public class BlockManagerDecommissioner
implements Logging {
    public final SparkConf org$apache$spark$storage$BlockManagerDecommissioner$$conf;
    public final BlockManager org$apache$spark$storage$BlockManagerDecommissioner$$bm;
    private final Option<FallbackStorage> org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage;
    private final int org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission;
    private volatile long lastRDDMigrationTime;
    private volatile long lastShuffleMigrationTime;
    private volatile boolean rddBlocksLeft;
    private volatile boolean shuffleBlocksLeft;
    private final HashSet<ShuffleBlockInfo> migratingShuffles;
    private final AtomicInteger numMigratedShuffles;
    private final ConcurrentLinkedQueue<Tuple2<ShuffleBlockInfo, Object>> shufflesToMigrate;
    private volatile boolean org$apache$spark$storage$BlockManagerDecommissioner$$stopped;
    private volatile boolean stoppedRDD;
    private volatile boolean org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle;
    private final HashMap<BlockManagerId, ShuffleMigrationRunnable> migrationPeers;
    private final Option<ThreadPoolExecutor> rddBlockMigrationExecutor;
    private final Runnable rddBlockMigrationRunnable;
    private final Option<ThreadPoolExecutor> shuffleBlockMigrationRefreshExecutor;
    private final Runnable shuffleBlockMigrationRefreshRunnable;
    private final Option<ThreadPoolExecutor> shuffleMigrationPool;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<FallbackStorage> org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage;
    }

    public int org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission;
    }

    public long lastRDDMigrationTime() {
        return this.lastRDDMigrationTime;
    }

    public void lastRDDMigrationTime_$eq(long x$1) {
        this.lastRDDMigrationTime = x$1;
    }

    public long lastShuffleMigrationTime() {
        return this.lastShuffleMigrationTime;
    }

    public void lastShuffleMigrationTime_$eq(long x$1) {
        this.lastShuffleMigrationTime = x$1;
    }

    public boolean rddBlocksLeft() {
        return this.rddBlocksLeft;
    }

    public void rddBlocksLeft_$eq(boolean x$1) {
        this.rddBlocksLeft = x$1;
    }

    public boolean shuffleBlocksLeft() {
        return this.shuffleBlocksLeft;
    }

    public void shuffleBlocksLeft_$eq(boolean x$1) {
        this.shuffleBlocksLeft = x$1;
    }

    public HashSet<ShuffleBlockInfo> migratingShuffles() {
        return this.migratingShuffles;
    }

    public AtomicInteger numMigratedShuffles() {
        return this.numMigratedShuffles;
    }

    public ConcurrentLinkedQueue<Tuple2<ShuffleBlockInfo, Object>> shufflesToMigrate() {
        return this.shufflesToMigrate;
    }

    public boolean org$apache$spark$storage$BlockManagerDecommissioner$$stopped() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped;
    }

    private void org$apache$spark$storage$BlockManagerDecommissioner$$stopped_$eq(boolean x$1) {
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped = x$1;
    }

    public boolean stoppedRDD() {
        return this.stoppedRDD;
    }

    public void stoppedRDD_$eq(boolean x$1) {
        this.stoppedRDD = x$1;
    }

    public boolean org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() {
        return this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle;
    }

    public void org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle_$eq(boolean x$1) {
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle = x$1;
    }

    private HashMap<BlockManagerId, ShuffleMigrationRunnable> migrationPeers() {
        return this.migrationPeers;
    }

    private Option<ThreadPoolExecutor> rddBlockMigrationExecutor() {
        return this.rddBlockMigrationExecutor;
    }

    private Runnable rddBlockMigrationRunnable() {
        return this.rddBlockMigrationRunnable;
    }

    private Option<ThreadPoolExecutor> shuffleBlockMigrationRefreshExecutor() {
        return this.shuffleBlockMigrationRefreshExecutor;
    }

    private Runnable shuffleBlockMigrationRefreshRunnable() {
        return this.shuffleBlockMigrationRefreshRunnable;
    }

    private Option<ThreadPoolExecutor> shuffleMigrationPool() {
        return this.shuffleMigrationPool;
    }

    public boolean refreshMigratableShuffleBlocks() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Start refreshing migratable shuffle blocks");
        Set localShuffles = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.migratableResolver().getStoredShuffles().toSet();
        Seq newShufflesToMigrate = (Seq)localShuffles.diff(this.migratingShuffles()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)b -> new Tuple2.mcIJ.sp(b.shuffleId(), b.mapId()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Long$.MODULE$));
        this.shufflesToMigrate().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)newShufflesToMigrate.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)0)), Seq$.MODULE$.canBuildFrom())).asJava());
        this.migratingShuffles().$plus$plus$eq((TraversableOnce)newShufflesToMigrate);
        int remainedShuffles = this.migratingShuffles().size() - this.numMigratedShuffles().get();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append(newShufflesToMigrate.size()).append(" of ").append(localShuffles.size()).append(" local shuffles ").append("are added. In total, ").append(remainedShuffles).append(" shuffles are remained.").toString());
        Set livePeerSet = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.getPeers(false).toSet();
        Set currentPeerSet = this.migrationPeers().keys().toSet();
        Set deadPeers = (Set)currentPeerSet.diff((GenSet)livePeerSet);
        Seq newPeers = Utils$.MODULE$.randomize(livePeerSet.diff((GenSet)currentPeerSet), ClassTag$.MODULE$.apply(BlockManagerId.class));
        this.migrationPeers().$plus$plus$eq((TraversableOnce)newPeers.map((Function1 & Serializable & scala.Serializable)peer -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Starting thread to migrate shuffle blocks to ").append(peer).toString());
            ShuffleMigrationRunnable runnable = new ShuffleMigrationRunnable(this, (BlockManagerId)peer);
            this.shuffleMigrationPool().foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.submit(runnable));
            return new Tuple2(peer, (Object)runnable);
        }, Seq$.MODULE$.canBuildFrom()));
        deadPeers.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BlockManagerDecommissioner.$anonfun$refreshMigratableShuffleBlocks$8(this, x$6);
            return BoxedUnit.UNIT;
        });
        if (!this.migrationPeers().values().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.keepRunning()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No available peers to receive Shuffle blocks, stop migration.");
            this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle_$eq(true);
        }
        return newShufflesToMigrate.nonEmpty() || this.migratingShuffles().size() > this.numMigratedShuffles().get();
    }

    public void stopMigratingShuffleBlocks() {
        this.shuffleMigrationPool().foreach((Function1 & Serializable & scala.Serializable)threadPool -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping migrating shuffle blocks.");
            this.migrationPeers().values().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                x$9.keepRunning_$eq(false);
                return BoxedUnit.UNIT;
            });
            return threadPool.shutdownNow();
        });
    }

    public boolean decommissionRddCacheBlocks() {
        Seq<BlockManagerMessages.ReplicateBlock> replicateBlocksInfo = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.getMigratableRDDBlocks();
        if (!replicateBlocksInfo.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to decommission RDD cache blocks, but no blocks to migrate");
            return false;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Need to replicate ").append(replicateBlocksInfo.size()).append(" RDD blocks ").append("for block manager decommissioning").toString());
        Seq blocksFailedReplication = (Seq)((TraversableLike)((TraversableLike)replicateBlocksInfo.map((Function1 & Serializable & scala.Serializable)replicateBlock -> {
            boolean replicatedSuccessfully = this.migrateBlock((BlockManagerMessages.ReplicateBlock)replicateBlock);
            return new Tuple2((Object)replicateBlock.blockId(), (Object)BoxesRunTime.boxToBoolean((boolean)replicatedSuccessfully));
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10._2$mcZ$sp()))).map((Function1 & Serializable & scala.Serializable)x$11 -> (BlockId)x$11._1(), Seq$.MODULE$.canBuildFrom());
        if (blocksFailedReplication.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Blocks failed replication in cache decommissioning ").append("process: ").append(blocksFailedReplication.mkString(",")).toString());
            return true;
        }
        return false;
    }

    private boolean migrateBlock(BlockManagerMessages.ReplicateBlock blockToReplicate) {
        boolean replicatedSuccessfully = this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.replicateBlock(blockToReplicate.blockId(), (Set<BlockManagerId>)blockToReplicate.replicas().toSet(), blockToReplicate.maxReplicas(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission())));
        if (replicatedSuccessfully) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Block ").append(blockToReplicate.blockId()).append(" migrated successfully, Removing block now").toString());
            this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.removeBlock(blockToReplicate.blockId(), this.org$apache$spark$storage$BlockManagerDecommissioner$$bm.removeBlock$default$2());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Block ").append(blockToReplicate.blockId()).append(" removed").toString());
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Failed to migrate block ").append(blockToReplicate.blockId()).toString());
        }
        return replicatedSuccessfully;
    }

    public void start() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting block migration");
        this.rddBlockMigrationExecutor().foreach((Function1 & Serializable & scala.Serializable)x$12 -> x$12.submit(this.rddBlockMigrationRunnable()));
        this.shuffleBlockMigrationRefreshExecutor().foreach((Function1 & Serializable & scala.Serializable)x$13 -> x$13.submit(this.shuffleBlockMigrationRefreshRunnable()));
    }

    public void stop() {
        if (this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped()) {
            return;
        }
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped_$eq(true);
        try {
            this.rddBlockMigrationExecutor().foreach((Function1 & Serializable & scala.Serializable)x$14 -> x$14.shutdownNow());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown RDD block migration thread", e);
            }
            throw throwable;
        }
        try {
            this.shuffleBlockMigrationRefreshExecutor().foreach((Function1 & Serializable & scala.Serializable)x$15 -> x$15.shutdownNow());
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown shuffle block refreshing thread", e);
            }
            throw throwable;
        }
        try {
            this.stopMigratingShuffleBlocks();
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable4);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error during shutdown shuffle block migration thread", e);
            }
            throw throwable;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped block migration");
    }

    public Tuple2<Object, Object> lastMigrationInfo() {
        if (this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped() || this.stoppedRDD() && this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle()) {
            return new Tuple2.mcJZ.sp(Long.MAX_VALUE, true);
        }
        long lastMigrationTime = !this.stoppedRDD() && !this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() ? Math.min(this.lastRDDMigrationTime(), this.lastShuffleMigrationTime()) : (!this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() ? this.lastShuffleMigrationTime() : this.lastRDDMigrationTime());
        boolean blocksMigrated = !(this.shuffleBlocksLeft() && !this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle() || this.rddBlocksLeft() && !this.stoppedRDD());
        return new Tuple2.mcJZ.sp(lastMigrationTime, blocksMigrated);
    }

    public static final /* synthetic */ void $anonfun$refreshMigratableShuffleBlocks$8(BlockManagerDecommissioner $this, BlockManagerId x$6) {
        $this.migrationPeers().get((Object)x$6).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.keepRunning_$eq(false);
            return BoxedUnit.UNIT;
        });
    }

    public BlockManagerDecommissioner(SparkConf conf, BlockManager bm) {
        this.org$apache$spark$storage$BlockManagerDecommissioner$$conf = conf;
        this.org$apache$spark$storage$BlockManagerDecommissioner$$bm = bm;
        Logging.$init$((Logging)this);
        this.org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage = FallbackStorage$.MODULE$.getFallbackStorage(conf);
        this.org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_MAX_REPLICATION_FAILURE_PER_BLOCK()));
        this.lastRDDMigrationTime = 0L;
        this.lastShuffleMigrationTime = 0L;
        this.rddBlocksLeft = true;
        this.shuffleBlocksLeft = true;
        this.migratingShuffles = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.numMigratedShuffles = new AtomicInteger(0);
        this.shufflesToMigrate = new ConcurrentLinkedQueue();
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stopped = false;
        this.stoppedRDD = !BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_RDD_BLOCKS_ENABLED()));
        this.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle = !BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED()));
        this.migrationPeers = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.rddBlockMigrationExecutor = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_RDD_BLOCKS_ENABLED())) ? new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("block-manager-decommission-rdd")) : None$.MODULE$;
        this.rddBlockMigrationRunnable = new Runnable(this){
            private final long sleepInterval;
            private final /* synthetic */ BlockManagerDecommissioner $outer;

            public long sleepInterval() {
                return this.sleepInterval;
            }

            public void run() {
                this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to migrate all RDD blocks");
                while (!this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stopped() && !this.$outer.stoppedRDD()) {
                    if (!this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$bm.getPeers(false).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$run$18(x$4)))) {
                        this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No available peers to receive RDD blocks, stop migration.");
                        this.$outer.stoppedRDD_$eq(true);
                        continue;
                    }
                    try {
                        long startTime = System.nanoTime();
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to migrate all cached RDD blocks");
                        this.$outer.rddBlocksLeft_$eq(this.$outer.decommissionRddCacheBlocks());
                        this.$outer.lastRDDMigrationTime_$eq(startTime);
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Finished current round RDD blocks migration, ").append("waiting for ").append(this.sleepInterval()).append("ms before the next round migration.").toString());
                        Thread.sleep(this.sleepInterval());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof InterruptedException) {
                            this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Stop RDD blocks migration").append((Object)(!$this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stopped() && !$this.$outer.stoppedRDD() ? " unexpectedly" : BoxedUnit.UNIT)).append(".").toString());
                            this.$outer.stoppedRDD_$eq(true);
                            continue;
                        }
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred during RDD blocks migration.", e);
                            this.$outer.stoppedRDD_$eq(true);
                            continue;
                        }
                        throw throwable;
                    }
                }
            }

            public static final /* synthetic */ boolean $anonfun$run$18(BlockManagerId x$4) {
                BlockManagerId blockManagerId = x$4;
                BlockManagerId blockManagerId2 = FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID();
                return blockManagerId == null ? blockManagerId2 != null : !((Object)blockManagerId).equals(blockManagerId2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sleepInterval = BoxesRunTime.unboxToLong((Object)$outer.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_REPLICATION_REATTEMPT_INTERVAL()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$17(), $anonfun$run$18$adapted(org.apache.spark.storage.BlockManagerId ), $anonfun$run$19(), $anonfun$run$20(), $anonfun$run$21(org.apache.spark.storage.BlockManagerDecommissioner$$anon$1 ), $anonfun$run$22(org.apache.spark.storage.BlockManagerDecommissioner$$anon$1 ), $anonfun$run$23()}, serializedLambda);
            }
        };
        this.shuffleBlockMigrationRefreshExecutor = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED())) ? new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("block-manager-decommission-shuffle")) : None$.MODULE$;
        this.shuffleBlockMigrationRefreshRunnable = new Runnable(this){
            private final long sleepInterval;
            private final /* synthetic */ BlockManagerDecommissioner $outer;

            public long sleepInterval() {
                return this.sleepInterval;
            }

            public void run() {
                this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to migrate all shuffle blocks");
                while (!this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stopped() && !this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle()) {
                    try {
                        long startTime = System.nanoTime();
                        this.$outer.shuffleBlocksLeft_$eq(this.$outer.refreshMigratableShuffleBlocks());
                        this.$outer.lastShuffleMigrationTime_$eq(startTime);
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Finished current round refreshing migratable shuffle blocks, ").append("waiting for ").append(this.sleepInterval()).append("ms before the next round refreshing.").toString());
                        Thread.sleep(this.sleepInterval());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof InterruptedException && this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stopped()) {
                            this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stop refreshing migratable shuffle blocks.");
                            continue;
                        }
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred during shuffle blocks migration.", e);
                            this.$outer.org$apache$spark$storage$BlockManagerDecommissioner$$stoppedShuffle_$eq(true);
                            continue;
                        }
                        throw throwable;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sleepInterval = BoxesRunTime.unboxToLong((Object)$outer.org$apache$spark$storage$BlockManagerDecommissioner$$conf.get(package$.MODULE$.STORAGE_DECOMMISSION_REPLICATION_REATTEMPT_INTERVAL()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$24(), $anonfun$run$25(org.apache.spark.storage.BlockManagerDecommissioner$$anon$2 ), $anonfun$run$26(), $anonfun$run$27()}, serializedLambda);
            }
        };
        this.shuffleMigrationPool = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_BLOCKS_ENABLED())) ? new Some((Object)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("migrate-shuffles", BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_MAX_THREADS())), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3())) : None$.MODULE$;
    }

    private class ShuffleMigrationRunnable
    implements Runnable {
        private final BlockManagerId peer;
        private volatile boolean keepRunning;
        public final /* synthetic */ BlockManagerDecommissioner $outer;

        public boolean keepRunning() {
            return this.keepRunning;
        }

        public void keepRunning_$eq(boolean x$1) {
            this.keepRunning = x$1;
        }

        private boolean allowRetry(ShuffleBlockInfo shuffleBlock, int failureNum) {
            if (failureNum < this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission()) {
                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Add ").append(shuffleBlock).append(" back to migration queue for ").append("retry (").append(failureNum).append(" / ").append(this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission()).append(")").toString());
                return this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().shufflesToMigrate().add((Tuple2<ShuffleBlockInfo, Object>)new Tuple2((Object)shuffleBlock, (Object)BoxesRunTime.boxToInteger((int)failureNum)));
            }
            this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Give up migrating ").append(shuffleBlock).append(" since it's been ").append("failed for ").append(this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission()).append(" times").toString());
            return false;
        }

        private Tuple2<ShuffleBlockInfo, Object> nextShuffleBlockToMigrate() {
            while (!Thread.currentThread().isInterrupted()) {
                Option option = Option$.MODULE$.apply(this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().shufflesToMigrate().poll());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Tuple2 head = (Tuple2)some.value();
                    return head;
                }
                if (None$.MODULE$.equals(option)) {
                    Thread.sleep(1000L);
                    continue;
                }
                throw new MatchError((Object)option);
            }
            throw SparkCoreErrors$.MODULE$.interruptedError();
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$1(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable ), ()Ljava/lang/String;)((ShuffleMigrationRunnable)this));
            while (this.keepRunning()) {
                try {
                    block17: {
                        block16: {
                            var6_2 = this.nextShuffleBlockToMigrate();
                            if (var6_2 == null) {
                                throw new MatchError(var6_2);
                            }
                            shuffleBlockInfo = (ShuffleBlockInfo)var6_2._1();
                            retryCount = var6_2._2$mcI$sp();
                            var5_1 = new Tuple2((Object)shuffleBlockInfo, (Object)BoxesRunTime.boxToInteger((int)retryCount));
                            shuffleBlockInfo = (ShuffleBlockInfo)var5_1._1();
                            retryCount = var5_1._2$mcI$sp();
                            blocks = this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm.migratableResolver().getMigrationBlocks(shuffleBlockInfo);
                            if (!blocks.isEmpty()) break block16;
                            this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$2(org.apache.spark.shuffle.ShuffleBlockInfo ), ()Ljava/lang/String;)((ShuffleBlockInfo)shuffleBlockInfo));
                            break block17;
                        }
                        this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$3(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable scala.collection.immutable.List org.apache.spark.shuffle.ShuffleBlockInfo int ), ()Ljava/lang/String;)((ShuffleMigrationRunnable)this, blocks, (ShuffleBlockInfo)shuffleBlockInfo, (int)retryCount));
                        try {
                            startTime = System.currentTimeMillis();
                            if (!this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage().isDefined()) ** GOTO lbl-1000
                            v0 = this.peer;
                            var14_9 = FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID();
                            if (!(v0 != null ? v0.equals(var14_9) == false : var14_9 != null)) {
                                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$4$adapted(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable org.apache.spark.shuffle.ShuffleBlockInfo org.apache.spark.storage.FallbackStorage ), (Lorg/apache/spark/storage/FallbackStorage;)Ljava/lang/Object;)((ShuffleMigrationRunnable)this, (ShuffleBlockInfo)shuffleBlockInfo));
                            } else lbl-1000:
                            // 2 sources

                            {
                                blocks.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$5$adapted(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ShuffleMigrationRunnable)this));
                            }
                            this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$8(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable org.apache.spark.shuffle.ShuffleBlockInfo scala.collection.immutable.List long ), ()Ljava/lang/String;)((ShuffleMigrationRunnable)this, (ShuffleBlockInfo)shuffleBlockInfo, blocks, (long)startTime));
                        }
                        catch (Throwable var15_10) {
                            block18: {
                                var16_11 = var15_10;
                                if (!(var16_11 instanceof IOException != false ? true : var16_11 instanceof SparkException != false)) break block18;
                                if (this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm.migratableResolver().getMigrationBlocks(shuffleBlockInfo).size() < blocks.size()) {
                                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$10(org.apache.spark.shuffle.ShuffleBlockInfo ), ()Ljava/lang/String;)((ShuffleBlockInfo)shuffleBlockInfo));
                                }
                                if (!this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage().isDefined()) ** GOTO lbl-1000
                                v1 = this.peer;
                                var17_12 = FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID();
                                if (v1 == null ? var17_12 != null : v1.equals(var17_12) == false) {
                                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$fallbackStorage().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$11$adapted(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable org.apache.spark.shuffle.ShuffleBlockInfo org.apache.spark.storage.FallbackStorage ), (Lorg/apache/spark/storage/FallbackStorage;)Ljava/lang/Object;)((ShuffleMigrationRunnable)this, (ShuffleBlockInfo)shuffleBlockInfo));
                                } else lbl-1000:
                                // 2 sources

                                {
                                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$12(org.apache.spark.shuffle.ShuffleBlockInfo ), ()Ljava/lang/String;)((ShuffleBlockInfo)shuffleBlockInfo), var16_11);
                                    this.keepRunning_$eq(false);
                                }
                            }
                            if (var16_11 instanceof Exception) {
                                var18_13 = (Exception)var16_11;
                                this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$13(org.apache.spark.shuffle.ShuffleBlockInfo ), ()Ljava/lang/String;)((ShuffleBlockInfo)shuffleBlockInfo), var18_13);
                                this.keepRunning_$eq(false);
                            }
                            throw var15_10;
                        }
                    }
                    if (this.keepRunning()) {
                        v2 /* !! */  = BoxesRunTime.boxToInteger((int)this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().numMigratedShuffles().incrementAndGet());
                        continue;
                    }
                    this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$14(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable ), ()Ljava/lang/String;)((ShuffleMigrationRunnable)this));
                    if (!this.allowRetry(shuffleBlockInfo, retryCount + 1)) {
                        v2 /* !! */  = BoxesRunTime.boxToInteger((int)this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().numMigratedShuffles().incrementAndGet());
                        continue;
                    }
                    v2 /* !! */  = BoxedUnit.UNIT;
                }
                catch (Throwable var19_14) {
                    var20_15 = var19_14;
                    if (var20_15 instanceof InterruptedException) {
                        this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$15(org.apache.spark.storage.BlockManagerDecommissioner$ShuffleMigrationRunnable ), ()Ljava/lang/String;)((ShuffleMigrationRunnable)this));
                        this.keepRunning_$eq(false);
                        v2 /* !! */  = BoxedUnit.UNIT;
                        continue;
                    }
                    var21_16 = NonFatal$.MODULE$.unapply(var20_15);
                    if (!var21_16.isEmpty()) {
                        e = (Throwable)var21_16.get();
                        this.keepRunning_$eq(false);
                        this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$run$16(), ()Ljava/lang/String;)(), e);
                        v2 /* !! */  = BoxedUnit.UNIT;
                        continue;
                    }
                    throw var19_14;
                }
            }
        }

        public /* synthetic */ BlockManagerDecommissioner org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ String $anonfun$run$1(ShuffleMigrationRunnable $this) {
            return new StringBuilder(44).append("Starting shuffle block migration thread for ").append($this.peer).toString();
        }

        public static final /* synthetic */ String $anonfun$run$2(ShuffleBlockInfo shuffleBlockInfo$1) {
            return new StringBuilder(29).append("Ignore deleted shuffle block ").append(shuffleBlockInfo$1).toString();
        }

        public static final /* synthetic */ String $anonfun$run$3(ShuffleMigrationRunnable $this, List blocks$1, ShuffleBlockInfo shuffleBlockInfo$1, int retryCount$1) {
            return new StringBuilder(55).append("Got migration sub-blocks ").append(blocks$1).append(". Trying to migrate ").append(shuffleBlockInfo$1).append(" ").append("to ").append($this.peer).append(" (").append(retryCount$1).append(" / ").append($this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$maxReplicationFailuresForDecommission()).append(")").toString();
        }

        public static final /* synthetic */ void $anonfun$run$5(ShuffleMigrationRunnable $this, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlockId blockId = (BlockId)tuple2._1();
                ManagedBuffer buffer = (ManagedBuffer)tuple2._2();
                $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Migrating sub-block ").append(blockId).toString());
                $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm.blockTransferService().uploadBlockSync($this.peer.host(), $this.peer.port(), $this.peer.executorId(), blockId, buffer, StorageLevel$.MODULE$.DISK_ONLY(), null);
                $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Migrated sub-block ").append(blockId).toString());
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public static final /* synthetic */ long $anonfun$run$9(Tuple2 b) {
            return ((ManagedBuffer)b._2()).size();
        }

        public static final /* synthetic */ String $anonfun$run$8(ShuffleMigrationRunnable $this, ShuffleBlockInfo shuffleBlockInfo$1, List blocks$1, long startTime$1) {
            return new StringBuilder(29).append("Migrated ").append(shuffleBlockInfo$1).append(" (").append("size: ").append(Utils$.MODULE$.bytesToString(BoxesRunTime.unboxToLong((Object)((TraversableOnce)blocks$1.map((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToLong((long)ShuffleMigrationRunnable.$anonfun$run$9(b)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))).append(") to ").append($this.peer).append(" ").append("in ").append(System.currentTimeMillis() - startTime$1).append(" ms").toString();
        }

        public static final /* synthetic */ String $anonfun$run$10(ShuffleBlockInfo shuffleBlockInfo$1) {
            return new StringBuilder(31).append("Skipping block ").append(shuffleBlockInfo$1).append(", block deleted.").toString();
        }

        public static final /* synthetic */ String $anonfun$run$12(ShuffleBlockInfo shuffleBlockInfo$1) {
            return new StringBuilder(32).append("Error occurred during migrating ").append(shuffleBlockInfo$1).toString();
        }

        public static final /* synthetic */ String $anonfun$run$13(ShuffleBlockInfo shuffleBlockInfo$1) {
            return new StringBuilder(32).append("Error occurred during migrating ").append(shuffleBlockInfo$1).toString();
        }

        public static final /* synthetic */ String $anonfun$run$14(ShuffleMigrationRunnable $this) {
            return new StringBuilder(33).append("Stop migrating shuffle blocks to ").append($this.peer).toString();
        }

        public static final /* synthetic */ String $anonfun$run$15(ShuffleMigrationRunnable $this) {
            return new StringBuilder(29).append("Stop shuffle block migration").append((Object)($this.keepRunning() ? " unexpectedly" : BoxedUnit.UNIT)).append(".").toString();
        }

        public static final /* synthetic */ String $anonfun$run$16() {
            return "Error occurred during shuffle blocks migration.";
        }

        public ShuffleMigrationRunnable(BlockManagerDecommissioner $outer, BlockManagerId peer) {
            this.peer = peer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.keepRunning = true;
        }

        public static final /* synthetic */ Object $anonfun$run$4$adapted(ShuffleMigrationRunnable $this, ShuffleBlockInfo shuffleBlockInfo$1, FallbackStorage x$2) {
            x$2.copy(shuffleBlockInfo$1, $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm);
            return BoxedUnit.UNIT;
        }

        public static final /* synthetic */ Object $anonfun$run$5$adapted(ShuffleMigrationRunnable $this, Tuple2 x0$1) {
            ShuffleMigrationRunnable.$anonfun$run$5($this, x0$1);
            return BoxedUnit.UNIT;
        }

        public static final /* synthetic */ Object $anonfun$run$11$adapted(ShuffleMigrationRunnable $this, ShuffleBlockInfo shuffleBlockInfo$1, FallbackStorage x$3) {
            x$3.copy(shuffleBlockInfo$1, $this.org$apache$spark$storage$BlockManagerDecommissioner$ShuffleMigrationRunnable$$$outer().org$apache$spark$storage$BlockManagerDecommissioner$$bm);
            return BoxedUnit.UNIT;
        }
    }
}

