/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.services.ClasspathURLConverterImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;

public class URLChangeTracker {
    private static final long FILE_DOES_NOT_EXIST_TIMESTAMP = -1L;
    private final Map<File, Long> fileToTimestamp = CollectionFactory.newConcurrentMap();
    private final boolean granularitySeconds;
    private final boolean trackFolderChanges;
    private final ClasspathURLConverter classpathURLConverter;
    public static final ClasspathURLConverter DEFAULT_CONVERTER = new ClasspathURLConverterImpl();

    public URLChangeTracker() {
        this(DEFAULT_CONVERTER, false, false);
    }

    public URLChangeTracker(ClasspathURLConverter classpathURLConverter) {
        this(classpathURLConverter, false);
    }

    public URLChangeTracker(ClasspathURLConverter classpathURLConverter, boolean granularitySeconds) {
        this(classpathURLConverter, granularitySeconds, true);
    }

    public URLChangeTracker(ClasspathURLConverter classpathURLConverter, boolean granularitySeconds, boolean trackFolderChanges) {
        this.granularitySeconds = granularitySeconds;
        this.classpathURLConverter = classpathURLConverter;
        this.trackFolderChanges = trackFolderChanges;
    }

    public static File toFileFromFileProtocolURL(URL url) {
        assert (url != null);
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException(String.format("URL %s does not use the 'file' protocol.", url));
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }

    public long add(URL url) {
        File dir;
        if (url == null) {
            return 0L;
        }
        URL converted = this.classpathURLConverter.convert(url);
        if (!converted.getProtocol().equals("file")) {
            return this.timestampForNonFileURL(converted);
        }
        File resourceFile = URLChangeTracker.toFileFromFileProtocolURL(converted);
        if (this.fileToTimestamp.containsKey(resourceFile)) {
            return this.fileToTimestamp.get(resourceFile);
        }
        long timestamp = this.readTimestamp(resourceFile);
        this.fileToTimestamp.put(resourceFile, timestamp);
        if (this.trackFolderChanges && !this.fileToTimestamp.containsKey(dir = resourceFile.getParentFile())) {
            long dirTimestamp = this.readTimestamp(dir);
            this.fileToTimestamp.put(dir, dirTimestamp);
        }
        return timestamp;
    }

    private long timestampForNonFileURL(URL url) {
        long timestamp;
        try {
            timestamp = url.openConnection().getLastModified();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.applyGranularity(timestamp);
    }

    public void clear() {
        this.fileToTimestamp.clear();
    }

    public boolean containsChanges() {
        boolean result = false;
        for (Map.Entry<File, Long> entry : this.fileToTimestamp.entrySet()) {
            long newTimestamp = this.readTimestamp(entry.getKey());
            long current = entry.getValue();
            if (current == newTimestamp) continue;
            result = true;
            entry.setValue(newTimestamp);
        }
        return result;
    }

    private long readTimestamp(File file) {
        if (!file.exists()) {
            return -1L;
        }
        return this.applyGranularity(file.lastModified());
    }

    private long applyGranularity(long timestamp) {
        if (this.granularitySeconds) {
            return timestamp - timestamp % 1000L;
        }
        return timestamp;
    }

    public void forceChange() {
        for (Map.Entry<File, Long> e : this.fileToTimestamp.entrySet()) {
            e.setValue(0L);
        }
    }

    int trackedFileCount() {
        return this.fileToTimestamp.size();
    }
}

