/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.jcache.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolverFactory;
import javax.inject.Singleton;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.jcache.internal.TapestryIoCInternalCacheInvocationContext;
import org.apache.tapestry5.jcache.internal.TapestryIoCInternalCacheKeyInvocationContext;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.jsr107.ri.annotations.AbstractCacheLookupUtil;
import org.jsr107.ri.annotations.InternalCacheInvocationContext;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;
import org.jsr107.ri.annotations.StaticCacheInvocationContext;
import org.jsr107.ri.annotations.StaticCacheKeyInvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CacheLookupUtil
extends AbstractCacheLookupUtil<MethodInvocation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheLookupUtil.class);
    private static final Pattern SERVICE_PROXY_CLASS_NAME = Pattern.compile("\\$.+_[a-f0-9]+");
    private final ObjectLocator objectLocator;
    private final CacheKeyGenerator defaultCacheKeyGenerator;
    private final CacheResolverFactory defaultCacheResolverFactory;

    public CacheLookupUtil(ObjectLocator objectLocator, CacheKeyGenerator defaultCacheKeyGenerator, CacheResolverFactory defaultCacheResolverFactory) {
        this.objectLocator = objectLocator;
        this.defaultCacheKeyGenerator = defaultCacheKeyGenerator;
        this.defaultCacheResolverFactory = defaultCacheResolverFactory;
    }

    protected InternalCacheKeyInvocationContext<? extends Annotation> createCacheKeyInvocationContextImpl(StaticCacheKeyInvocationContext<? extends Annotation> staticCacheKeyInvocationContext, MethodInvocation invocation) {
        return new TapestryIoCInternalCacheKeyInvocationContext<Annotation>(staticCacheKeyInvocationContext, invocation);
    }

    protected InternalCacheInvocationContext<? extends Annotation> createCacheInvocationContextImpl(StaticCacheInvocationContext<? extends Annotation> staticCacheInvocationContext, MethodInvocation invocation) {
        return new TapestryIoCInternalCacheInvocationContext<Annotation>(staticCacheInvocationContext, invocation);
    }

    protected Class<?> getTargetClass(MethodInvocation invocation) {
        Object instance = invocation.getInstance();
        Class<?> clasz = instance.getClass();
        if (SERVICE_PROXY_CLASS_NAME.matcher(clasz.getName()).matches()) {
            clasz = this.getDelegateType(instance);
        }
        return clasz;
    }

    private Class<?> getDelegateType(Object instance) {
        Object delegate = instance;
        Class<?> clasz = delegate.getClass();
        if (SERVICE_PROXY_CLASS_NAME.matcher(clasz.getName()).matches()) {
            try {
                delegate = this.getDelegate(delegate, clasz);
                clasz = this.getDelegateType(delegate);
            }
            catch (Exception e) {
                LOGGER.error("Exception while getting service implementation type", (Throwable)e);
                throw new RuntimeException("Exception while getting service implementation type", e);
            }
        }
        return clasz;
    }

    private Object getDelegate(Object instance, Class<?> clasz) throws IllegalAccessException, InvocationTargetException {
        try {
            return clasz.getDeclaredMethod("_____internalGetDelegate_DONT_CALL_THIS_METHOD_____", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Couldn't find method %s in %s", "_____internalGetDelegate_DONT_CALL_THIS_METHOD_____", instance.getClass().getName()));
        }
    }

    protected Method getMethod(MethodInvocation invocation) {
        Class<?> targetClass;
        Method method = invocation.getMethod();
        Class<?> methodClass = method.getClass();
        if (methodClass != (targetClass = this.getTargetClass(invocation))) {
            method = this.findMethod(method, targetClass);
        }
        return method;
    }

    private Method findMethod(Method method, Class<?> targetClass) {
        try {
            return targetClass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T getObjectByType(Class<T> type) {
        return (T)this.objectLocator.getObject(type, null);
    }

    protected CacheKeyGenerator getDefaultCacheKeyGenerator() {
        return this.defaultCacheKeyGenerator;
    }

    protected CacheResolverFactory getDefaultCacheResolverFactory() {
        return this.defaultCacheResolverFactory;
    }
}

