/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.internal.services.PropertyValueLabelProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.SelectModelFactory;
import org.apache.tapestry5.services.ValueEncoderSource;
import org.apache.tapestry5.services.ValueLabelProvider;

public class SelectModelFactoryImpl
implements SelectModelFactory {
    private final PropertyAccess propertyAccess;
    private final ValueEncoderSource valueEncoderSource;
    private final ValueLabelProvider<Object> valueLabelProvider;

    public SelectModelFactoryImpl(PropertyAccess propertyAccess, ValueEncoderSource valueEncoderSource, ValueLabelProvider<Object> valueLabelProvider) {
        this.propertyAccess = propertyAccess;
        this.valueEncoderSource = valueEncoderSource;
        this.valueLabelProvider = valueLabelProvider;
    }

    @Override
    public SelectModel create(List<?> objects, String labelProperty) {
        PropertyValueLabelProvider propertyValueLabelProvider = new PropertyValueLabelProvider(this.valueEncoderSource, this.propertyAccess, labelProperty);
        return this.createSelectModel(objects, propertyValueLabelProvider);
    }

    @Override
    public SelectModel create(List<?> objects) {
        return this.createSelectModel(objects, this.valueLabelProvider);
    }

    private SelectModel createSelectModel(List<?> objects, ValueLabelProvider<Object> labelProvider) {
        List options = CollectionFactory.newList();
        for (Object object : objects) {
            String label = labelProvider.getLabel(object);
            options.add(new OptionModelImpl(label, object));
        }
        return new SelectModelImpl(null, options);
    }
}

