/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.commons.AnnotationProvider;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.internal.services.AnnotationProviderChain;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.internal.ObjectCreatorSource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class ServiceDefImpl
implements ServiceDef3 {
    private final Class serviceInterface;
    private final Class serviceImplementation;
    private final String serviceId;
    private final String scope;
    private final boolean eagerLoad;
    private final ObjectCreatorSource source;
    private final Set<Class> markers;
    private final boolean preventDecoration;

    ServiceDefImpl(Class serviceInterface, Class serviceImplementation, String serviceId, Set<Class> markers, String scope, boolean eagerLoad, boolean preventDecoration, ObjectCreatorSource source) {
        this.serviceInterface = serviceInterface;
        this.serviceImplementation = serviceImplementation;
        this.serviceId = serviceId;
        this.scope = scope;
        this.eagerLoad = eagerLoad;
        this.preventDecoration = preventDecoration;
        this.source = source;
        this.markers = markers;
    }

    public String toString() {
        return this.source.getDescription();
    }

    @Override
    public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
        return this.source.constructCreator(resources);
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    @Override
    public Class getServiceImplementation() {
        return this.serviceImplementation;
    }

    @Override
    public String getServiceScope() {
        return this.scope;
    }

    @Override
    public boolean isEagerLoad() {
        return this.eagerLoad;
    }

    @Override
    public Set<Class> getMarkers() {
        return this.markers;
    }

    @Override
    public boolean isPreventDecoration() {
        return this.preventDecoration;
    }

    private Flow<Class> searchPath() {
        return (Flow)F.flow((Object[])new Class[]{this.serviceImplementation, this.serviceInterface}).removeNulls();
    }

    @Override
    public AnnotationProvider getClassAnnotationProvider() {
        return AnnotationProviderChain.create((List)this.searchPath().map(InternalUtils.CLASS_TO_AP_MAPPER).toList());
    }

    @Override
    public AnnotationProvider getMethodAnnotationProvider(final String methodName, final Class ... argumentTypes) {
        return AnnotationProviderChain.create((List)this.searchPath().map((Mapper)new Mapper<Class, Method>(){

            public Method map(Class element) {
                return InternalUtils.findMethod(element, methodName, argumentTypes);
            }
        }).map(InternalUtils.METHOD_TO_AP_MAPPER).toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDefImpl)) {
            return false;
        }
        ServiceDef other = (ServiceDef)obj;
        return !(this.serviceId == null ? other.getServiceId() != null : !this.serviceId.equals(other.getServiceId()));
    }
}

