/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.MultiKey;
import org.apache.tapestry5.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry5.internal.parser.ComponentTemplate;
import org.apache.tapestry5.internal.parser.TemplateToken;
import org.apache.tapestry5.internal.services.ComponentTemplateSource;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.internal.services.TemplateParser;
import org.apache.tapestry5.internal.services.TemplateTrackingInfo;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.services.UpdateListener;
import org.apache.tapestry5.ioc.services.UpdateListenerHub;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.pageload.ComponentRequestSelectorAnalyzer;
import org.apache.tapestry5.services.pageload.ComponentResourceLocator;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

public final class ComponentTemplateSourceImpl
extends InvalidationEventHubImpl
implements ComponentTemplateSource,
UpdateListener {
    private final TemplateParser parser;
    private final URLChangeTracker<TemplateTrackingInfo> tracker;
    private final ComponentResourceLocator locator;
    private final ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer;
    private final ThreadLocale threadLocale;
    private final Logger logger;
    private final boolean multipleClassLoaders;
    private final Map<MultiKey, Resource> templateResources = CollectionFactory.newConcurrentMap();
    private final Map<Resource, ComponentTemplate> templates = CollectionFactory.newConcurrentMap();
    private final ComponentTemplate missingTemplate = new ComponentTemplate(){

        @Override
        public Map<String, Location> getComponentIds() {
            return Collections.emptyMap();
        }

        @Override
        public Resource getResource() {
            return null;
        }

        @Override
        public List<TemplateToken> getTokens() {
            return Collections.emptyList();
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public List<TemplateToken> getExtensionPointTokens(String extensionPointId) {
            return null;
        }

        @Override
        public boolean isExtension() {
            return false;
        }

        @Override
        public boolean usesStrictMixinParameters() {
            return false;
        }

        @Override
        public Set<String> getExtensionPointIds() {
            return Collections.emptySet();
        }
    };

    public ComponentTemplateSourceImpl(@Inject @Symbol(value="tapestry.production-mode") boolean productionMode, @Inject @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders, TemplateParser parser, ComponentResourceLocator locator, ClasspathURLConverter classpathURLConverter, ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer, ThreadLocale threadLocale, Logger logger) {
        this(productionMode, multipleClassLoaders, parser, locator, (URLChangeTracker<TemplateTrackingInfo>)new URLChangeTracker(classpathURLConverter), componentRequestSelectorAnalyzer, threadLocale, logger);
    }

    ComponentTemplateSourceImpl(boolean productionMode, boolean multipleClassLoaders, TemplateParser parser, ComponentResourceLocator locator, URLChangeTracker<TemplateTrackingInfo> tracker, ComponentRequestSelectorAnalyzer componentRequestSelectorAnalyzer, ThreadLocale threadLocale, Logger logger) {
        super(productionMode, logger);
        this.parser = parser;
        this.locator = locator;
        this.tracker = tracker;
        this.componentRequestSelectorAnalyzer = componentRequestSelectorAnalyzer;
        this.threadLocale = threadLocale;
        this.logger = logger;
        this.multipleClassLoaders = multipleClassLoaders;
    }

    @PostInjection
    public void registerAsUpdateListener(UpdateListenerHub hub) {
        hub.addUpdateListener((UpdateListener)this);
    }

    @PostInjection
    public void setupReload(ReloadHelper helper) {
        helper.addReloadCallback(new Runnable(){

            @Override
            public void run() {
                ComponentTemplateSourceImpl.this.invalidate();
            }
        });
    }

    @Override
    public ComponentTemplate getTemplate(ComponentModel componentModel, ComponentResourceSelector selector) {
        ComponentTemplate result;
        String componentName = componentModel.getComponentClassName();
        MultiKey key = new MultiKey(new Object[]{componentName, selector});
        Resource resource = this.templateResources.get(key);
        if (resource == null) {
            resource = this.locateTemplateResource(componentModel, selector);
            this.templateResources.put(key, resource);
        }
        if ((result = this.templates.get(resource)) == null) {
            result = this.parseTemplate(resource, componentModel.getComponentClassName());
            this.templates.put(resource, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentTemplate getTemplate(ComponentModel componentModel, Locale locale) {
        Locale original = this.threadLocale.getLocale();
        try {
            this.threadLocale.setLocale(locale);
            ComponentTemplate componentTemplate = this.getTemplate(componentModel, this.componentRequestSelectorAnalyzer.buildSelectorForRequest());
            return componentTemplate;
        }
        finally {
            this.threadLocale.setLocale(original);
        }
    }

    private ComponentTemplate parseTemplate(Resource r, String className) {
        if (!r.exists()) {
            return this.missingTemplate;
        }
        this.tracker.add(r.toURL(), (Object)new TemplateTrackingInfo(r.getPath(), className));
        return this.parser.parseTemplate(r);
    }

    private Resource locateTemplateResource(ComponentModel initialModel, ComponentResourceSelector selector) {
        for (ComponentModel model = initialModel; model != null; model = model.getParentModel()) {
            Resource localized = this.locator.locateTemplate(model, selector);
            if (localized == null) continue;
            return localized;
        }
        return initialModel.getBaseResource().withExtension("tml");
    }

    public void checkForUpdates() {
        Set changedResourcesInfo = this.tracker.getChangedResourcesInfo();
        if (!changedResourcesInfo.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Changed template(s) found: {}", (Object)String.join((CharSequence)", ", changedResourcesInfo.stream().map(TemplateTrackingInfo::getTemplate).collect(Collectors.toList())));
            }
            if (this.multipleClassLoaders) {
                Iterator<Map.Entry<MultiKey, Resource>> templateResourcesIterator = this.templateResources.entrySet().iterator();
                for (TemplateTrackingInfo info : changedResourcesInfo) {
                    while (templateResourcesIterator.hasNext()) {
                        MultiKey key = templateResourcesIterator.next().getKey();
                        if (!info.getClassName().equals((String)key.getValues()[0])) continue;
                        this.templates.remove(this.templateResources.get(key));
                        templateResourcesIterator.remove();
                    }
                }
                this.fireInvalidationEvent(changedResourcesInfo.stream().map(TemplateTrackingInfo::getClassName).collect(Collectors.toList()));
            } else {
                this.invalidate();
            }
        }
    }

    private void invalidate() {
        this.tracker.clear();
        this.templateResources.clear();
        this.templates.clear();
        this.fireInvalidationEvent();
    }

    @Override
    public InvalidationEventHub getInvalidationEventHub() {
        return this;
    }
}

