/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.clojure;

import clojure.lang.Symbol;
import java.lang.reflect.Method;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.clojure.MethodToFunctionSymbolMapper;

public class DefaultMapper
implements MethodToFunctionSymbolMapper {
    private final Pattern transition = Pattern.compile("(\\p{Lower}\\p{Upper})");

    @Override
    public Symbol mapMethod(String namespace, Method method) {
        return this.mapMethodName(namespace, method.getName());
    }

    private Symbol mapMethodName(String namespace, String name) {
        return Symbol.create((String)namespace, (String)this.transformName(name));
    }

    private String transformName(String name) {
        Matcher matcher = this.transition.matcher(name);
        StringBuilder builder = new StringBuilder();
        int lastx = 0;
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            int start = matchResult.start();
            int end = matchResult.end();
            builder.append(name.substring(lastx, start + 1));
            builder.append('-');
            builder.append(name.substring(end - 1, end).toLowerCase());
            lastx = end;
        }
        if (lastx == 0) {
            return name;
        }
        builder.append(name.substring(lastx));
        return builder.toString();
    }
}

