/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.eclipse.andmore.android.wizards.monkey;

/**
 * This interface holds the constants for MonkeyConfiguration
 */

public interface IMonkeyConfigurationConstants {

	public final static String LAUNCH_CONFIGURATION_TYPE_EXTENSION_ID = "monkeyLaunchConfigurationType";

	public final static String ANDMORE_APP_ICO = "icons/monkey/monkey_16.png";

	public final static String DEFAULT_VALUE = "";

	public final static String DEFAULT_COUNT_VALUE = "50";

	public final static String DEFAULT_VERBOSE_VALUE = "-v";

	public final static boolean DEFAULT_BOOL_VALUE = false;

	public final static String ATTR_DEVICE_INSTANCE_NAME = "org.eclipse.andmore.android.monkey.instanceName";

	public final static String ANDROID_CONSOLE_ID = "Android";

	public static final String ATTR_EVENT_COUNT_NAME = "";

	public static final String ATTR_OTHER_CMDS = "org.eclipse.andmore.android.monkey.otherCmds";

	public static final String ATTR_SELECTED_PACKAGES = "org.eclipse.andmore.android.monkey.selectedPackages";

	public static final String NEW_CONFIGURATION_NAME = "New_configuration";

}
