/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android;

import java.awt.Dimension;
import java.util.HashMap;
import org.eclipse.sequoyah.localization.android.i18n.Messages;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleAttribute;

public class AndroidLocaleAttribute
extends LocaleAttribute {
    private int androidType;
    private String stringValue = "";
    protected boolean isSet = false;

    public AndroidLocaleAttribute(Object object, int n) {
        super("", LocaleAttribute.STRING_TYPE, 0, 0, null, "", "");
        this.androidType = n;
        this.setAndroidValue(object);
        this.isSet = false;
    }

    public AndroidLocaleAttribute(String string, int n) {
        super("", LocaleAttribute.STRING_TYPE, 0, 0, null, "", "");
        this.androidType = n;
        Object object = this.getValueAndTypeFromQualifier(string);
        this.setAndroidValue(object);
    }

    public int getAndroidType() {
        return this.androidType;
    }

    private String getCountryCodeFolder(String string) {
        return "mcc" + string;
    }

    private String getLanguageFolder(String string) {
        return string.toLowerCase();
    }

    private String getNetworkCodeFolder(String string) {
        return "mnc" + string;
    }

    private String getPixelFolder(String string) {
        return String.valueOf(string) + "dpi";
    }

    private String getRegionCodeFolder(String string) {
        return "r" + string.toUpperCase();
    }

    public String getStringValue() {
        return this.stringValue;
    }

    private Object getValueAndTypeFromQualifier(String string) {
        Object object = null;
        if (this.androidType == AndroidLocaleAttributes.COUNTRY_CODE.ordinal()) {
            object = string.substring(3);
        } else if (this.androidType == AndroidLocaleAttributes.NETWORK_CODE.ordinal()) {
            object = string.substring(3);
        } else if (this.androidType == AndroidLocaleAttributes.LANGUAGE.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.REGION.ordinal()) {
            object = string.substring(1);
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_SIZE.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.DOCK_MODE.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.NIGHT_MODE.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()) {
            int n = string.indexOf("dpi");
            object = string.substring(0, n);
        } else if (this.androidType == AndroidLocaleAttributes.TOUCH_TYPE.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()) {
            String[] stringArray = string.split("x");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            object = new Dimension(n, n2);
        } else if (this.androidType == AndroidLocaleAttributes.API_VERSION.ordinal()) {
            object = string.substring(0, string.length());
        } else if (this.androidType == AndroidLocaleAttributes.SMALLEST_WIDTH.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.AVAILABLE_WIDTH.ordinal()) {
            object = string;
        } else if (this.androidType == AndroidLocaleAttributes.AVAILABLE_HEIGHT.ordinal()) {
            object = string;
        }
        return object;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void setAndroidValue(Object object) {
        if (this.androidType == AndroidLocaleAttributes.COUNTRY_CODE.ordinal()) {
            this.setCountryCodeNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.NETWORK_CODE.ordinal()) {
            this.setNetworkCodeNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.LANGUAGE.ordinal()) {
            this.setLanguageNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.REGION.ordinal()) {
            this.setRegionNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_SIZE.ordinal()) {
            this.setScreenSizeNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_ASPECT.ordinal()) {
            this.setScreenAspectNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_ORIENTATION.ordinal()) {
            this.setOrientationNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.DOCK_MODE.ordinal()) {
            this.setDockNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.NIGHT_MODE.ordinal()) {
            this.setNightNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.PIXEL_DENSITY.ordinal()) {
            this.setPixelNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.TOUCH_TYPE.ordinal()) {
            this.setTouchNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.KEYBOARD_STATE.ordinal()) {
            this.setKeyboardNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.TEXT_INPUT_METHOD.ordinal()) {
            this.setTextInputNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.NAVIGATION_KEY_STATE.ordinal()) {
            this.setNavigationKeyStateNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.NAVIGATION_METHOD.ordinal()) {
            this.setNavigationNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.SCREEN_DIMENSION.ordinal()) {
            this.setDimensionNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.API_VERSION.ordinal()) {
            this.setAPIVersionNode(object);
        } else if (this.androidType == AndroidLocaleAttributes.SMALLEST_WIDTH.ordinal()) {
            this.setSmallestWidthValue(object);
        } else if (this.androidType == AndroidLocaleAttributes.AVAILABLE_WIDTH.ordinal()) {
            this.setAvailableWidthValue(object);
        } else if (this.androidType == AndroidLocaleAttributes.AVAILABLE_HEIGHT.ordinal()) {
            this.setAvailableHeightValue(object);
        } else {
            throw new IllegalArgumentException(Messages.Unknown_Andr_Type);
        }
        this.isSet = true;
    }

    public void setAttribute() {
        this.isSet = true;
    }

    private void setCountryCodeNode(Object object) {
        this.displayName = "Country Code";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 3;
        this.maximumSize = 3;
        this.allowedValues = null;
        this.setIntValue(object);
        this.folderValue = this.getCountryCodeFolder(this.displayValue);
    }

    private void setScreenAspectNode(Object object) {
        this.displayName = "Screen Ratio";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setDockNode(Object object) {
        this.displayName = "Dock Mode";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setNightNode(Object object) {
        this.displayName = "Night Mode";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setNavigationKeyStateNode(Object object) {
        this.displayName = "Navigation State";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setDimensionNode(Object object) {
        if (!(object instanceof Dimension)) {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        this.displayName = "Screen Dimension";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = null;
        double d = ((Dimension)object).getWidth();
        double d2 = ((Dimension)object).getHeight();
        this.folderValue = this.displayValue = String.valueOf((int)d2) + "x" + (int)d;
    }

    private void setScreenSizeNode(Object object) {
        this.displayName = "Screen Size";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setStringValue(object);
    }

    public void setIntValue(Object object) {
        Integer n = -1;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof String) {
            n = Integer.parseInt((String)object);
        } else {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        if (this.fixedSize > 0 && n.toString().length() != this.fixedSize) {
            throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.fixedSize);
        }
        if (this.maximumSize > 0 && n.toString().length() > this.maximumSize) {
            throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.maximumSize);
        }
        this.displayValue = n.toString();
    }

    private void setKeyboardNode(Object object) {
        this.displayName = "Keyboard State";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setLanguageNode(Object object) {
        this.displayName = "Language";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 2;
        this.maximumSize = 2;
        this.allowedValues = null;
        this.setStringValue(object);
        this.folderValue = this.getLanguageFolder(this.displayValue);
    }

    private void setNavigationNode(Object object) {
        this.displayName = "Navigation Method";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setNetworkCodeNode(Object object) {
        this.displayName = "Network Code";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 3;
        this.allowedValues = null;
        this.setIntValue(object);
        this.folderValue = this.getNetworkCodeFolder(this.displayValue);
    }

    private void setAPIVersionNode(Object object) {
        this.displayName = "API Version";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 3;
        this.allowedValues = null;
        this.setAPIValue(object);
        this.folderValue = this.displayValue;
    }

    private void setAPIValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            String string2 = string.substring(1, string.length());
            try {
                Integer.valueOf(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
            }
            this.displayValue = (String)object;
        }
    }

    private void setOrientationNode(Object object) {
        this.displayName = "Screen Orientation";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = new HashMap();
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setPixelNode(Object object) {
        this.displayName = "Pixel Density";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.allowedValues = null;
        this.setStringValue(object);
        this.folderValue = this.getPixelFolder(this.displayValue);
    }

    private void setRegionNode(Object object) {
        this.displayName = "Region";
        this.type = LocaleAttribute.STRING_TYPE;
        this.fixedSize = 2;
        this.maximumSize = 2;
        this.allowedValues = null;
        this.setStringValue(object);
        this.folderValue = this.getRegionCodeFolder(this.displayValue);
    }

    private void setStringValue(Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(Messages.Invalid_Andr_Value);
        }
        if (this.type == FIXED_TEXT_TYPE) {
            this.setValuesBasedOnDisplayValue((String)object);
        } else {
            if (this.fixedSize > 0 && ((String)object).length() != this.fixedSize) {
                throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.fixedSize);
            }
            if (this.maximumSize > 0 && ((String)object).length() > this.maximumSize) {
                throw new IllegalArgumentException(String.valueOf(Messages.Invalid_Andr_Value_Size) + this.maximumSize);
            }
            this.displayValue = (String)object;
        }
    }

    public void setStringValue(String string) {
        this.stringValue = string;
    }

    private void setTextInputNode(Object object) {
        this.displayName = "Text Input Method";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setTouchNode(Object object) {
        this.displayName = "Touch Screen Type";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setSmallestWidthValue(Object object) {
        this.displayName = "smallestWidth";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setAvailableWidthValue(Object object) {
        this.displayName = "Available width";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.setValuesBasedOnDisplayValue((String)object);
    }

    private void setAvailableHeightValue(Object object) {
        this.displayName = "Available height";
        this.type = LocaleAttribute.FIXED_TEXT_TYPE;
        this.fixedSize = 0;
        this.maximumSize = 0;
        this.setValuesBasedOnDisplayValue((String)object);
    }

    public void unsetAttribute() {
        this.isSet = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AndroidLocaleAttributes {
        COUNTRY_CODE,
        NETWORK_CODE,
        LANGUAGE,
        REGION,
        SCREEN_SIZE,
        SCREEN_ASPECT,
        SCREEN_ORIENTATION,
        SMALLEST_WIDTH,
        AVAILABLE_WIDTH,
        AVAILABLE_HEIGHT,
        DOCK_MODE,
        NIGHT_MODE,
        PIXEL_DENSITY,
        TOUCH_TYPE,
        KEYBOARD_STATE,
        TEXT_INPUT_METHOD,
        NAVIGATION_KEY_STATE,
        NAVIGATION_METHOD,
        SCREEN_DIMENSION,
        API_VERSION,
        COUNT;

    }
}

