/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android.manager;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.FileUtil;
import org.eclipse.sequoyah.device.common.utilities.exception.AbstractExceptionStatus;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahExceptionStatus;
import org.eclipse.sequoyah.localization.android.IAndroidLocalizationSchemaConstants;
import org.eclipse.sequoyah.localization.android.LocalizationXMLParserFilter;
import org.eclipse.sequoyah.localization.android.datamodel.AndroidStringLocalizationFile;
import org.eclipse.sequoyah.localization.android.i18n.Messages;
import org.eclipse.sequoyah.localization.android.manager.ArrayStringNodeManager;
import org.eclipse.sequoyah.localization.android.manager.ILocalizationFileManager;
import org.eclipse.sequoyah.localization.android.manager.LocalizationFileManagerFactory;
import org.eclipse.sequoyah.localization.android.manager.NodeManager;
import org.eclipse.sequoyah.localization.android.manager.NodeManagerProvider;
import org.eclipse.sequoyah.localization.android.manager.StringNodeManager;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileFactory;
import org.eclipse.sequoyah.localization.tools.datamodel.StringLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayItemNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringNode;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLocalizationFileManager
extends ILocalizationFileManager
implements IAndroidLocalizationSchemaConstants {
    private IProject localizationFileProject = null;

    static {
        LocalizationFileManagerFactory.getInstance().addManager(StringLocalizationFileManager.class.getName(), StringLocalizationFileManager.class);
    }

    public static ILocalizationFileManager create() {
        return new StringLocalizationFileManager();
    }

    @Override
    public LocalizationFile loadFile(LocalizationFile localizationFile) throws SequoyahException {
        Object object2;
        if (!localizationFile.getFile().exists()) {
            object2 = new LocalizationFileBean(localizationFile);
            object2.setType(StringLocalizationFile.class.getName());
            for (NodeManager object3 : NodeManagerProvider.getInstance().getNodeManagers()) {
                object3.loadFile((LocalizationFileBean)object2, localizationFile);
            }
            LocalizationFile localizationFile2 = LocalizationFileFactory.getInstance().createLocalizationFile((LocalizationFileBean)object2);
            try {
                this.createFile(localizationFile2);
            }
            catch (SequoyahException sequoyahException) {
                BasePlugin.getLogger().error((Object)"Could not create StringLocalizationFile: ", (Object)sequoyahException);
            }
        }
        try {
            Document document;
            if (System.getProperty("java.version").startsWith("1.5")) {
                object2 = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                document = documentBuilder.parse(new File(localizationFile.getFile().getLocation().toString()));
            } else {
                object2 = new FileInputStream(localizationFile.getFile().getLocation().toFile());
                DOMImplementation dOMImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("XML 3.0");
                DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
                LSInput lSInput = dOMImplementationLS.createLSInput();
                LSParser lSParser = dOMImplementationLS.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
                LocalizationXMLParserFilter localizationXMLParserFilter = new LocalizationXMLParserFilter();
                lSParser.setFilter(localizationXMLParserFilter);
                lSInput.setEncoding("UTF-8");
                lSInput.setByteStream((InputStream)object2);
                document = lSParser.parse(lSInput);
            }
            this.updateLocalizationFileContent(localizationFile, document);
        }
        catch (Exception exception) {
            SequoyahExceptionStatus sequoyahExceptionStatus = new SequoyahExceptionStatus(4, "org.eclipse.sequoyah.localization.android", 0, String.valueOf(Messages.StringLocalizationFileManager_Exception_CouldNotLoadFile) + localizationFile.getFile().getFullPath().toOSString() + ". " + exception.getMessage(), (Throwable)exception);
            throw new SequoyahException((AbstractExceptionStatus)sequoyahExceptionStatus);
        }
        return localizationFile;
    }

    private void updateLocalizationFileContent(LocalizationFile localizationFile, Document document) {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        ArrayList<StringNode> arrayList2 = new ArrayList<StringNode>();
        for (NodeManager object2 : NodeManagerProvider.getInstance().getNodeManagers()) {
            if (object2 instanceof StringNodeManager) {
                object2.updateLocalizationFileContent(document, arrayList);
                continue;
            }
            if (!(object2 instanceof ArrayStringNodeManager)) continue;
            ((ArrayStringNodeManager)object2).updateLocalizationFileContent(document, arrayList2);
        }
        ((AndroidStringLocalizationFile)localizationFile).setSavedXMLDocument(document);
        ((AndroidStringLocalizationFile)localizationFile).clearStringNodes();
        ((AndroidStringLocalizationFile)localizationFile).setStringNodes(arrayList);
        ArrayList<StringArrayNode> arrayList3 = new ArrayList<StringArrayNode>();
        for (StringNode stringNode : arrayList2) {
            arrayList3.add((StringArrayNode)stringNode);
        }
        ((AndroidStringLocalizationFile)localizationFile).setStringArrayNodes(arrayList3);
    }

    @Override
    public void createFile(LocalizationFile localizationFile) throws SequoyahException {
        try {
            DocumentBuilder documentBuilder;
            DocumentBuilderFactory documentBuilderFactory;
            String string = localizationFile.getFile().getFullPath().toOSString();
            if (!localizationFile.getFile().exists()) {
                localizationFile.getFile().getLocation();
                documentBuilderFactory = null;
                documentBuilderFactory = localizationFile.getLocalizationProject() != null ? new Path(localizationFile.getLocalizationProject().getProject().getLocation() + string) : localizationFile.getFile().getLocation();
                documentBuilderFactory.removeLastSegments(1).toFile().mkdirs();
                documentBuilderFactory.toFile().createNewFile();
                if (localizationFile.getLocalizationProject() != null) {
                    documentBuilder = localizationFile.getLocalizationProject().getProject().getFile((IPath)new Path(string));
                    localizationFile.setFile((IFile)documentBuilder);
                }
            }
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("resources");
            for (NodeManager nodeManager : NodeManagerProvider.getInstance().getNodeManagers()) {
                nodeManager.createFile(document, element, localizationFile);
            }
            document.appendChild(element);
            this.saveXMLDocument(localizationFile.getFile().getLocation().toFile(), document);
            ((AndroidStringLocalizationFile)localizationFile).setSavedXMLDocument(document);
            localizationFile.getFile().getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            throw new SequoyahException();
        }
    }

    private void saveXMLDocument(File file, Document document) throws TransformerFactoryConfigurationError, TransformerConfigurationException, FileNotFoundException, UnsupportedEncodingException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        try {
            StreamResult streamResult = new StreamResult(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            this.removeXMLDocumentBlankNodes(document);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.unescapeEntity(file);
    }

    private void unescapeEntity(File file) {
        File file2 = null;
        FilterOutputStream filterOutputStream = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                file2 = File.createTempFile("temp_localization", "dom");
                FileUtil.copyFile((File)file, (File)file2);
                fileInputStream = new FileInputStream(file2);
                fileOutputStream = new FileOutputStream(file);
                filterOutputStream = new DataOutputStream(fileOutputStream);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
                String string = null;
                if (bufferedReader != null) {
                    string = bufferedReader.readLine();
                    while (string != null) {
                        string = this.unescapeEntity(string);
                        filterOutputStream.write(string.getBytes("UTF-8"));
                        String string2 = this.getEndOfLine();
                        filterOutputStream.write(string2.getBytes("UTF-8"));
                        string = bufferedReader.readLine();
                    }
                }
            }
            catch (Exception exception) {
                BasePlugin.logError((String)"Error translating file.", (Throwable)exception);
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                        bufferedReader = null;
                    }
                }
                catch (IOException iOException) {
                    BasePlugin.logError((String)"Error cleaning up objects after translation", (Throwable)iOException);
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {
                        BasePlugin.logError((String)"Error closing file after translation", (Throwable)iOException);
                    }
                    filterOutputStream = null;
                }
                if (file2 != null && !file2.delete()) {
                    file2.deleteOnExit();
                }
                file = null;
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (IOException iOException) {
                BasePlugin.logError((String)"Error cleaning up objects after translation", (Throwable)iOException);
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    BasePlugin.logError((String)"Error closing file after translation", (Throwable)iOException);
                }
                filterOutputStream = null;
            }
            if (file2 != null && !file2.delete()) {
                file2.deleteOnExit();
            }
            file = null;
        }
    }

    private String getEndOfLine() {
        String string = null;
        Preferences preferences = Platform.getPreferencesService().getRootNode().node("instance");
        try {
            if (preferences != null && preferences.nodeExists("org.eclipse.core.runtime")) {
                string = preferences.node("org.eclipse.core.runtime").get("line.separator", null);
            }
        }
        catch (BackingStoreException backingStoreException) {}
        return string != null ? string : System.getProperty("line.separator");
    }

    private String unescapeEntity(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&lt;", "<");
        string2 = string2.replaceAll("&gt;", ">");
        string2 = string2.replaceAll("&#13;", "");
        return string2;
    }

    @Override
    public void updateFile(LocalizationFile localizationFile) throws SequoyahException {
        AndroidStringLocalizationFile androidStringLocalizationFile = (AndroidStringLocalizationFile)localizationFile;
        Document document = androidStringLocalizationFile.getSavedXMLDocument();
        this.updateFile((LocalizationFile)androidStringLocalizationFile, document);
        if (document == null) {
            document = androidStringLocalizationFile.getSavedXMLDocument();
        }
        try {
            this.localizationFileProject = localizationFile.getFile().getProject();
            this.saveXMLDocument(localizationFile.getFile().getLocation().toFile(), document);
        }
        catch (Exception exception) {
            SequoyahException sequoyahException = new SequoyahException();
            sequoyahException.setStackTrace(exception.getStackTrace());
            throw sequoyahException;
        }
        localizationFile.setDirty(false);
    }

    private void updateFile(LocalizationFile localizationFile, Document document) throws SequoyahException {
        AndroidStringLocalizationFile androidStringLocalizationFile = (AndroidStringLocalizationFile)localizationFile;
        if (document == null) {
            this.createFile((LocalizationFile)androidStringLocalizationFile);
            document = androidStringLocalizationFile.getSavedXMLDocument();
        } else {
            Object object2;
            HashMap<String, StringNode> hashMap = new HashMap<String, StringNode>();
            HashMap<String, StringArrayNode> hashMap2 = new HashMap<String, StringArrayNode>();
            for (Object object2 : ((StringLocalizationFile)localizationFile).getStringNodes()) {
                if (object2 instanceof StringArrayNode) continue;
                hashMap.put(object2.getKey(), (StringNode)object2);
            }
            for (Object object2 : ((StringLocalizationFile)localizationFile).getStringArrays()) {
                hashMap2.put(object2.getKey(), (StringArrayNode)object2);
            }
            object2 = document.getElementsByTagName("resources");
            if (object2.getLength() == 0) {
                Element element = document.createElement("resources");
                document.appendChild(element);
                object2 = document.getElementsByTagName("resources");
            }
            int n = 0;
            while (n < object2.getLength()) {
                Element element = (Element)object2.item(n);
                this.visitToRemoveDOMChildren(document, element.getFirstChild(), "name", androidStringLocalizationFile.getSingleEntryToRemove(), androidStringLocalizationFile.getArrayEntryToRemove(), androidStringLocalizationFile.getArrayItemsToRemove());
                this.visitToUpdateDOMChildren(document, element.getFirstChild(), "name", hashMap, hashMap2);
                this.visitToAddDOMChildren(document, hashMap, hashMap2, element);
                ++n;
            }
        }
    }

    public void visitToAddDOMChildren(Document document, Map<String, StringNode> map, Map<String, StringArrayNode> map2, Element element) {
        NodeManager nodeManager;
        StringNode stringNode;
        for (Map.Entry<String, StringNode> entry : map.entrySet()) {
            stringNode = entry.getValue();
            nodeManager = NodeManagerProvider.getInstance().getStringNodeManager();
            ((StringNodeManager)nodeManager).addSingleEntry(document, element, stringNode);
        }
        for (Map.Entry<String, StringNode> entry : map2.entrySet()) {
            stringNode = (StringArrayNode)entry.getValue();
            nodeManager = NodeManagerProvider.getInstance().getArrayStringNodeManager();
            ((ArrayStringNodeManager)nodeManager).addArrayEntry(document, element, (StringArrayNode)stringNode);
        }
    }

    public void visitToRemoveDOMChildren(Document document, Node node, String string, Map<String, StringNode> map, Map<String, StringArrayNode> map2, List<StringArrayItemNode> list) {
        while (node != null) {
            Attr attr;
            Node node2 = node.getNextSibling();
            if (node.getNodeType() == 1 && (attr = StringLocalizationFileManager.getAttribute((Element)node, string)) != null) {
                String string2 = attr.getValue();
                StringNode stringNode = map.get(string2);
                if (stringNode != null) {
                    node.getParentNode().removeChild(node);
                } else {
                    StringArrayNode stringArrayNode = map2.get(string2);
                    if (stringArrayNode != null) {
                        node.getParentNode().removeChild(node);
                    } else {
                        NodeList nodeList = node.getChildNodes();
                        int n = 0;
                        int n2 = 0;
                        while (n < nodeList.getLength()) {
                            Node node3 = nodeList.item(n);
                            if (node3 instanceof Element) {
                                Element element = (Element)node3;
                                Iterator<StringArrayItemNode> iterator = list.iterator();
                                StringArrayItemNode stringArrayItemNode = null;
                                while (iterator.hasNext() && stringArrayItemNode == null) {
                                    StringArrayItemNode stringArrayItemNode2 = iterator.next();
                                    if (!stringArrayItemNode2.getKey().equals(string2) || stringArrayItemNode2.getPosition() != n2) continue;
                                    stringArrayItemNode = stringArrayItemNode2;
                                }
                                if (stringArrayItemNode != null) {
                                    element.getParentNode().removeChild(element);
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                }
            }
            node = node2;
        }
    }

    public void visitToUpdateDOMChildren(Document document, Node node, String string, Map<String, StringNode> map, Map<String, StringArrayNode> map2) {
        while (node != null) {
            Attr attr;
            if (node.getNodeType() == 1 && (attr = StringLocalizationFileManager.getAttribute((Element)node, string)) != null) {
                Object object;
                String string2;
                String string3 = attr.getValue();
                StringNode stringNode = map.get(string3);
                if (stringNode != null) {
                    string2 = stringNode.getValue();
                    node.setTextContent(string2);
                    object = NodeManagerProvider.getInstance().getStringNodeManager();
                    ((NodeManager)object).createOrUpdateComment(document, stringNode, (Element)node);
                    map.remove(string3);
                } else {
                    string2 = map2.get(string3);
                    if (string2 != null) {
                        ArrayStringNodeManager arrayStringNodeManager;
                        Element element;
                        Node node2;
                        object = node.getChildNodes();
                        List list = string2.getValues();
                        int n = 0;
                        int n2 = 0;
                        while (n < object.getLength() && n2 < list.size()) {
                            node2 = object.item(n);
                            if (node2 instanceof Element) {
                                element = (Element)node2;
                                arrayStringNodeManager = (StringNode)list.get(n2);
                                String string4 = arrayStringNodeManager.getValue();
                                element.setTextContent(string4);
                                ArrayStringNodeManager arrayStringNodeManager2 = NodeManagerProvider.getInstance().getArrayStringNodeManager();
                                arrayStringNodeManager2.createOrUpdateComment(document, (StringNode)arrayStringNodeManager, element);
                                map2.remove(string3);
                                ++n2;
                            }
                            ++n;
                        }
                        while (n2 < list.size()) {
                            if (!(node instanceof Element)) continue;
                            node2 = (Element)node;
                            element = (StringNode)list.get(n2);
                            arrayStringNodeManager = NodeManagerProvider.getInstance().getArrayStringNodeManager();
                            arrayStringNodeManager.createArrayItem(document, (Element)node2, (StringNode)element);
                            ++n2;
                            map2.remove(string3);
                        }
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    public static Attr getAttribute(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        return attr;
    }

    private String getXMLAsString(Document document) {
        String string = null;
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            this.removeXMLDocumentBlankNodes(document);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            string = stringWriter.toString();
            string = this.unescapeEntity(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    /*
     * Could not resolve type clashes
     */
    void removeXMLDocumentBlankNodes(Document document) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        NodeList nodeList = document.getElementsByTagName("resources");
        if (nodeList.getLength() == 1) {
            Node node = nodeList.item(0);
            NodeList nodeList2 = node.getChildNodes();
            int n = 0;
            while (n < nodeList2.getLength()) {
                Node node2 = nodeList2.item(n);
                if (node2.getNodeType() == 3) {
                    arrayList.add(node2);
                } else if (node2.getNodeName().equals("string-array")) {
                    arrayList2.clear();
                    NodeList nodeList3 = node2.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList3.getLength()) {
                        Node node3 = nodeList3.item(n2);
                        if (node3.getNodeType() == 3) {
                            arrayList2.add(node3);
                        }
                        ++n2;
                    }
                    for (Node node4 : arrayList2) {
                        node2.removeChild(node4);
                    }
                }
                ++n;
            }
            for (Node node5 : arrayList) {
                node.removeChild(node5);
            }
        }
    }

    @Override
    public void updateLocalizationFileContent(LocalizationFile localizationFile, String string) throws SequoyahException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            Document document = documentBuilder.parse(byteArrayInputStream);
            this.updateLocalizationFileContent((LocalizationFile)((StringLocalizationFile)localizationFile), document);
        }
        catch (Exception exception) {
            SequoyahExceptionStatus sequoyahExceptionStatus = new SequoyahExceptionStatus(4, "org.eclipse.sequoyah.localization.android", 0, String.valueOf(Messages.AndroidLocalizationSchema_6) + localizationFile.getFile().getFullPath(), (Throwable)exception);
            throw new SequoyahException((AbstractExceptionStatus)sequoyahExceptionStatus);
        }
    }

    @Override
    public Object getLocalizationFileContent(LocalizationFile localizationFile) {
        String string = null;
        if (localizationFile instanceof AndroidStringLocalizationFile) {
            AndroidStringLocalizationFile androidStringLocalizationFile = (AndroidStringLocalizationFile)localizationFile;
            try {
                this.updateFile((LocalizationFile)androidStringLocalizationFile, androidStringLocalizationFile.getSavedXMLDocument());
            }
            catch (SequoyahException sequoyahException) {}
            string = this.getXMLAsString(androidStringLocalizationFile.getSavedXMLDocument());
        }
        return string;
    }
}

