/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.edit;

import java.text.DecimalFormat;
import org.eclipse.apogy.addons.powersystems.PowerBus;
import org.eclipse.apogy.addons.powersystems.PowerBusState;
import org.eclipse.apogy.addons.powersystems.provider.PowerBusItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class PowerBusCustomItemProvider
extends PowerBusItemProvider {
    private DecimalFormat decimalFormat = new DecimalFormat("0.000");

    public PowerBusCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        PowerBus powerBus = (PowerBus)object;
        String label = powerBus.getName();
        if (label == null || label.length() == 0) {
            label = this.getString("_UI_PowerBus_type");
        }
        label = String.valueOf(label) + " (" + powerBus.getPowerBusState() + ", ";
        if (powerBus.getPowerBusState() != PowerBusState.NOMINAL) {
            label = String.valueOf(label) + "Bus Oververload " + this.decimalFormat + powerBus.getBusPowerOverload() + "W,";
        }
        label = String.valueOf(label) + "Power Balance " + this.decimalFormat.format(powerBus.getPowerBalance()) + "W";
        label = String.valueOf(label) + ")";
        return label;
    }
}

