/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.DerivedUnit;
import javax.measure.unit.Unit;

public final class ProductUnit<Q extends Quantity>
extends DerivedUnit<Q> {
    private final Element[] _elements;
    private int _hashCode;
    private static final long serialVersionUID = 1L;

    ProductUnit() {
        this._elements = new Element[0];
    }

    public ProductUnit(Unit<?> productUnit) {
        this._elements = ((ProductUnit)productUnit)._elements;
    }

    private ProductUnit(Element[] elements) {
        this._elements = elements;
    }

    private static Unit<? extends Quantity> getInstance(Element[] leftElems, Element[] rightElems) {
        Unit unit;
        Element[] result = new Element[leftElems.length + rightElems.length];
        int resultIndex = 0;
        int i = 0;
        while (i < leftElems.length) {
            unit = leftElems[i]._unit;
            int p1 = leftElems[i]._pow;
            int r1 = leftElems[i]._root;
            int p2 = 0;
            int r2 = 1;
            int j = 0;
            while (j < rightElems.length) {
                if (unit.equals(rightElems[j]._unit)) {
                    p2 = rightElems[j]._pow;
                    r2 = rightElems[j]._root;
                    break;
                }
                ++j;
            }
            int pow = p1 * r2 + p2 * r1;
            int root = r1 * r2;
            if (pow != 0) {
                int gcd = ProductUnit.gcd(Math.abs(pow), root);
                result[resultIndex++] = new Element(unit, pow / gcd, root / gcd);
            }
            ++i;
        }
        i = 0;
        while (i < rightElems.length) {
            unit = rightElems[i]._unit;
            boolean hasBeenMerged = false;
            int j = 0;
            while (j < leftElems.length) {
                if (unit.equals(leftElems[j]._unit)) {
                    hasBeenMerged = true;
                    break;
                }
                ++j;
            }
            if (!hasBeenMerged) {
                result[resultIndex++] = rightElems[i];
            }
            ++i;
        }
        if (resultIndex == 0) {
            return ONE;
        }
        if (resultIndex == 1 && result[0]._pow == result[0]._root) {
            return result[0]._unit;
        }
        Element[] elems = new Element[resultIndex];
        int i2 = 0;
        while (i2 < resultIndex) {
            elems[i2] = result[i2];
            ++i2;
        }
        return new ProductUnit(elems);
    }

    static Unit<? extends Quantity> getProductInstance(Unit<?> left, Unit<?> right) {
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left)._elements : new Element[]{new Element(left, 1, 1)};
        Element[] rightElems = right instanceof ProductUnit ? ((ProductUnit)right)._elements : new Element[]{new Element(right, 1, 1)};
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    static Unit<? extends Quantity> getQuotientInstance(Unit<?> left, Unit<?> right) {
        Element[] rightElems;
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left)._elements : new Element[]{new Element(left, 1, 1)};
        if (right instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)right)._elements;
            rightElems = new Element[elems.length];
            int i = 0;
            while (i < elems.length) {
                rightElems[i] = new Element(elems[i]._unit, -elems[i]._pow, elems[i]._root);
                ++i;
            }
        } else {
            rightElems = new Element[]{new Element(right, -1, 1)};
        }
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    static Unit<? extends Quantity> getRootInstance(Unit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit)._elements;
            unitElems = new Element[elems.length];
            int i = 0;
            while (i < elems.length) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i]._pow), elems[i]._root * n);
                unitElems[i] = new Element(elems[i]._unit, elems[i]._pow / gcd, elems[i]._root * n / gcd);
                ++i;
            }
        } else {
            unitElems = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    static Unit<? extends Quantity> getPowInstance(Unit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit)._elements;
            unitElems = new Element[elems.length];
            int i = 0;
            while (i < elems.length) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i]._pow * n), elems[i]._root);
                unitElems[i] = new Element(elems[i]._unit, elems[i]._pow * n / gcd, elems[i]._root / gcd);
                ++i;
            }
        } else {
            unitElems = new Element[]{new Element(unit, n, 1)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public int getUnitCount() {
        return this._elements.length;
    }

    public Unit<? extends Quantity> getUnit(int index) {
        return this._elements[index].getUnit();
    }

    public int getUnitPow(int index) {
        return this._elements[index].getPow();
    }

    public int getUnitRoot(int index) {
        return this._elements[index].getRoot();
    }

    @Override
    public boolean equals(Object that) {
        Element[] elems;
        if (this == that) {
            return true;
        }
        if (that instanceof ProductUnit && this._elements.length == (elems = ((ProductUnit)that)._elements).length) {
            int i = 0;
            while (i < this._elements.length) {
                boolean unitFound = false;
                int j = 0;
                while (j < elems.length) {
                    if (this._elements[i]._unit.equals(elems[j]._unit)) {
                        if (this._elements[i]._pow != elems[j]._pow || this._elements[i]._root != elems[j]._root) {
                            return false;
                        }
                        unitFound = true;
                        break;
                    }
                    ++j;
                }
                if (!unitFound) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        int code = 0;
        int i = 0;
        while (i < this._elements.length) {
            code += this._elements[i]._unit.hashCode() * (this._elements[i]._pow * 3 - this._elements[i]._root * 2);
            ++i;
        }
        this._hashCode = code;
        return code;
    }

    @Override
    public Unit<? super Q> getStandardUnit() {
        if (this.hasOnlyStandardUnit()) {
            return this;
        }
        Unit<Quantity> systemUnit = ONE;
        int i = 0;
        while (i < this._elements.length) {
            Unit<Object> unit = this._elements[i]._unit.getStandardUnit();
            unit = unit.pow(this._elements[i]._pow);
            unit = unit.root(this._elements[i]._root);
            systemUnit = systemUnit.times(unit);
            ++i;
        }
        return systemUnit;
    }

    @Override
    public UnitConverter toStandardUnit() {
        if (this.hasOnlyStandardUnit()) {
            return UnitConverter.IDENTITY;
        }
        UnitConverter converter = UnitConverter.IDENTITY;
        int i = 0;
        while (i < this._elements.length) {
            UnitConverter cvtr = this._elements[i]._unit.toStandardUnit();
            if (!cvtr.isLinear()) {
                throw new ConversionException(this._elements[i]._unit + " is non-linear, cannot convert");
            }
            if (this._elements[i]._root != 1) {
                throw new ConversionException(this._elements[i]._unit + " holds a base unit with fractional exponent");
            }
            int pow = this._elements[i]._pow;
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            int j = 0;
            while (j < pow) {
                converter = converter.concatenate(cvtr);
                ++j;
            }
            ++i;
        }
        return converter;
    }

    private boolean hasOnlyStandardUnit() {
        int i = 0;
        while (i < this._elements.length) {
            Unit u = this._elements[i]._unit;
            if (!u.isStandardUnit()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return ProductUnit.gcd(n, m % n);
    }

    private static final class Element
    implements Serializable {
        private final Unit<?> _unit;
        private final int _pow;
        private final int _root;
        private static final long serialVersionUID = 1L;

        private Element(Unit<?> unit, int pow, int root) {
            this._unit = unit;
            this._pow = pow;
            this._root = root;
        }

        public Unit<?> getUnit() {
            return this._unit;
        }

        public int getPow() {
            return this._pow;
        }

        public int getRoot() {
            return this._root;
        }
    }
}

