/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDUtil {
    public static final String XSD_TYPE_DEFINITION = XSDPackage.eINSTANCE.getXSDTypeDefinition().getName();
    public static final String XSD_ELEMENT_DECLARATION = XSDPackage.eINSTANCE.getXSDElementDeclaration().getName();
    public static final String XSD_SCHEMA = XSDPackage.eINSTANCE.getXSDSchema().getName();

    public static boolean isSchemaType(String typeName) {
        return typeName == null ? false : XSD_TYPE_DEFINITION.equals(typeName) || XSD_ELEMENT_DECLARATION.equals(typeName);
    }

    public static EObject resolve(XSDSchema schema, QName qname, String name, String refType) {
        XSDTypeDefinition resolvedObject = null;
        if (XSD_TYPE_DEFINITION.equals(refType)) {
            resolvedObject = XSDUtil.resolveTypeDefinition(schema, qname);
        } else if (XSD_ELEMENT_DECLARATION.equals(refType)) {
            resolvedObject = XSDUtil.resolveElementDeclaration(schema, qname);
        } else {
            if (XSD_SCHEMA.equals(refType)) {
                return schema;
            }
            System.err.println(String.valueOf(XSDUtil.class.getName()) + ": unrecognized refType: " + refType);
        }
        return resolvedObject;
    }

    public static XSDElementDeclaration resolveElementDeclaration(XSDSchema schema, QName qname) {
        if (schema == null) {
            return null;
        }
        return schema.resolveElementDeclaration(XSDUtil.XSDNamespaceAdjust(qname.getNamespaceURI()), qname.getLocalPart());
    }

    public static XSDTypeDefinition resolveTypeDefinition(XSDSchema schema, QName qname) {
        if (schema == null) {
            return null;
        }
        return schema.resolveTypeDefinition(XSDUtil.XSDNamespaceAdjust(qname.getNamespaceURI()), qname.getLocalPart());
    }

    private static final String XSDNamespaceAdjust(String nsURI) {
        if ("".equals(nsURI)) {
            return null;
        }
        return nsURI;
    }
}

