/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.helpers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GetOpt {
    List<String> mParams = new ArrayList<String>(8);
    Map<Character, String> mOpt = new LinkedHashMap<Character, String>(11);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GetOpt(String strControl, String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            String sOpt = args[i];
            if (sOpt.length() < 1) {
                this.mParams.add(sOpt);
            } else {
                char ch1 = sOpt.charAt(0);
                if (ch1 != '-') {
                    this.mParams.add(sOpt);
                } else if (sOpt.length() >= 2) {
                    char ch2 = sOpt.charAt(1);
                    int nIndex = strControl.indexOf(ch2);
                    if (nIndex < 0) {
                        throw new Exception("Unknown command option " + ch2);
                    }
                    if (nIndex >= 0 && nIndex + 1 < strControl.length() && strControl.charAt(nIndex + 1) == ':') {
                        if (sOpt.length() > 2) {
                            this.mOpt.put(Character.valueOf(ch2), sOpt.substring(2));
                        } else {
                            if (i + 1 >= args.length) throw new Exception("Expected argument for option " + ch2);
                            this.mOpt.put(Character.valueOf(ch2), args[++i]);
                        }
                    } else {
                        int j = 1;
                        while (j < sOpt.length()) {
                            this.mOpt.put(Character.valueOf(sOpt.charAt(j)), "1");
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public char[] getOptions() {
        char[] options = new char[this.mOpt.size()];
        int x = 0;
        for (char ch : this.mOpt.keySet()) {
            options[x++] = ch;
        }
        return options;
    }

    public boolean hasOption(char c) {
        return this.mOpt.containsKey(Character.valueOf(c));
    }

    public String getOption(char c) {
        return this.mOpt.get(Character.valueOf(c));
    }

    public List<String> parameters() {
        return this.mParams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[GetOpt=").append(this.mOpt).append(",").append(this.mParams).append("]");
        return sb.toString();
    }
}

